/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CurtainBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final EnumProperty<CurtainShape> SHAPE = EnumProperty.m_61587_((String)"shape", CurtainShape.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_S = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SHAPE_E = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public CurtainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)((Object)CurtainShape.SINGLE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, SHAPE, OPEN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.computeShape(state, context.m_43725_(), pos)));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((direction.m_122434_().m_122479_() || direction == Direction.UP || direction == Direction.DOWN) && level instanceof Level) {
            Level realLevel = (Level)level;
            this.updateCurtainGroup(realLevel, pos);
            if (neighborState.m_60734_() instanceof CurtainBlock) {
                this.updateCurtainGroup(realLevel, neighborPos);
            }
        }
        return state;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockState s;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        boolean currentlyOpen = (Boolean)state.m_61143_((Property)OPEN);
        ArrayList<BlockPos> group = new ArrayList<BlockPos>();
        this.collectConnectedCurtains(level, pos, (Direction)state.m_61143_((Property)FACING), group);
        for (BlockPos p : group) {
            BlockState toggled;
            s = level.m_8055_(p);
            if (!(s.m_60734_() instanceof CurtainBlock) || s.equals(toggled = (BlockState)s.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)))) continue;
            level.m_7731_(p, toggled, 2);
        }
        for (BlockPos p : group) {
            CurtainBlock cBlock;
            BlockState newState;
            s = level.m_8055_(p);
            Block block = s.m_60734_();
            if (!(block instanceof CurtainBlock) || s.equals(newState = (BlockState)s.m_61124_(SHAPE, (Comparable)((Object)(cBlock = (CurtainBlock)block).computeShape(s, level, p))))) continue;
            level.m_7731_(p, newState, 2);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE_N;
            case Direction.EAST -> SHAPE_E;
            case Direction.WEST -> SHAPE_W;
            default -> SHAPE_S;
        };
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return this.m_5940_(state, worldIn, pos, context);
    }

    private void updateCurtainGroup(Level level, BlockPos origin) {
        BlockState originState = level.m_8055_(origin);
        if (!(originState.m_60734_() instanceof CurtainBlock)) {
            return;
        }
        ArrayList<BlockPos> group = new ArrayList<BlockPos>();
        this.collectConnectedCurtains(level, origin, (Direction)originState.m_61143_((Property)FACING), group);
        for (BlockPos p : group) {
            CurtainBlock cBlock;
            BlockState newState;
            BlockState oldState = level.m_8055_(p);
            Block block = oldState.m_60734_();
            if (!(block instanceof CurtainBlock) || oldState.equals(newState = (BlockState)oldState.m_61124_(SHAPE, (Comparable)((Object)(cBlock = (CurtainBlock)block).computeShape(oldState, level, p))))) continue;
            level.m_7731_(p, newState, 2);
        }
    }

    private void collectConnectedCurtains(Level level, BlockPos pos, Direction facing, List<BlockPos> group) {
        BlockPos rightPos;
        BlockPos leftPos;
        BlockPos below;
        if (group.contains(pos)) {
            return;
        }
        group.add(pos);
        Direction left = facing.m_122428_();
        Direction right = facing.m_122427_();
        BlockPos above = pos.m_7494_();
        if (this.isSameCurtain(level, above, facing)) {
            this.collectConnectedCurtains(level, above, facing, group);
        }
        if (this.isSameCurtain(level, below = pos.m_7495_(), facing)) {
            this.collectConnectedCurtains(level, below, facing, group);
        }
        if (this.isSameCurtain(level, leftPos = pos.m_121945_(left), facing)) {
            this.collectConnectedCurtains(level, leftPos, facing, group);
        }
        if (this.isSameCurtain(level, rightPos = pos.m_121945_(right), facing)) {
            this.collectConnectedCurtains(level, rightPos, facing, group);
        }
    }

    private boolean isSameCurtain(Level level, BlockPos pos, Direction facing) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockState s = level.m_8055_(pos);
        return s.m_60734_() instanceof CurtainBlock && s.m_61143_((Property)FACING) == facing;
    }

    public CurtainShape computeShape(BlockState state, Level level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction leftDir = facing.m_122428_();
        Direction rightDir = facing.m_122427_();
        BlockPos abovePos = pos.m_7494_();
        BlockPos belowPos = pos.m_7495_();
        BlockPos leftPos = pos.m_121945_(leftDir);
        BlockPos rightPos = pos.m_121945_(rightDir);
        boolean connectedAbove = this.isSameCurtain(level, abovePos, facing);
        boolean connectedBelow = this.isSameCurtain(level, belowPos, facing);
        boolean connectedLeft = this.isSameCurtain(level, leftPos, facing);
        boolean connectedRight = this.isSameCurtain(level, rightPos, facing);
        if (!(connectedAbove || connectedBelow || connectedLeft || connectedRight)) {
            return CurtainShape.SINGLE;
        }
        if (!connectedLeft && !connectedRight) {
            if (connectedAbove && connectedBelow) {
                return CurtainShape.VERTICAL_MIDDLE;
            }
            if (connectedAbove) {
                return CurtainShape.BOTTOM_SINGLE;
            }
            return CurtainShape.TOP_SINGLE;
        }
        if (!connectedAbove && !connectedBelow) {
            if (connectedLeft && connectedRight) {
                return CurtainShape.MIDDLE;
            }
            if (connectedLeft) {
                return CurtainShape.RIGHT;
            }
            return CurtainShape.LEFT;
        }
        if (connectedAbove && connectedBelow) {
            if (connectedLeft && connectedRight) {
                return CurtainShape.MIDDLE;
            }
            if (connectedLeft) {
                return CurtainShape.RIGHT;
            }
            return CurtainShape.LEFT;
        }
        if (connectedAbove) {
            if (connectedLeft && connectedRight) {
                return CurtainShape.BOTTOM_MIDDLE;
            }
            if (connectedLeft) {
                return CurtainShape.BOTTOM_RIGHT;
            }
            return CurtainShape.BOTTOM_LEFT;
        }
        if (connectedLeft && connectedRight) {
            return CurtainShape.TOP;
        }
        if (connectedLeft) {
            return CurtainShape.CORNER_RIGHT;
        }
        return CurtainShape.CORNER_LEFT;
    }

    public static enum CurtainShape implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        MIDDLE("middle"),
        RIGHT("right"),
        BOTTOM_SINGLE("bottom_single"),
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_MIDDLE("bottom_middle"),
        BOTTOM_RIGHT("bottom_right"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right"),
        TOP("curtain_top"),
        TOP_SINGLE("curtain_top_single"),
        VERTICAL_MIDDLE("vertical_middle");

        private final String name;

        private CurtainShape(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

