/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.YAFConfig;
import com.starfish_studios.yaf.block.entity.FlowerBasketBlockEntity;
import com.starfish_studios.yaf.util.block.BlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowerBasketBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final VoxelShape FLOOR_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    protected static final VoxelShape CEILING_AABB = Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    protected static final VoxelShape WALL_NORTH_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape WALL_SOUTH_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)10.0, (double)6.0);
    protected static final VoxelShape WALL_EAST_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0);
    protected static final VoxelShape WALL_WEST_AABB = Block.m_49796_((double)10.0, (double)4.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public FlowerBasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.FLOOR));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FlowerBasketBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        AttachFace face = (AttachFace)state.m_61143_(FACE);
        if (face == AttachFace.FLOOR) {
            return FLOOR_AABB;
        }
        if (face == AttachFace.CEILING) {
            return CEILING_AABB;
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> SHAPE;
            case Direction.NORTH -> WALL_NORTH_AABB;
            case Direction.SOUTH -> WALL_SOUTH_AABB;
            case Direction.EAST -> WALL_EAST_AABB;
            case Direction.WEST -> WALL_WEST_AABB;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FACE});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlowerBasketBlockEntity) {
            FlowerBasketBlockEntity flowerBoxBE = (FlowerBasketBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, flowerBoxBE.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        if (clickedFace.m_122434_() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(clickedFace == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)clickedFace);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean isAllowedFlower(Item item) {
        if (item == null) {
            return false;
        }
        ResourceLocation itemId = new ResourceLocation(item.toString());
        for (String entry : YAFConfig.flowerBasketItems) {
            if (entry.startsWith("#")) {
                String tagName = entry.substring(1);
                ResourceLocation tagResource = new ResourceLocation(tagName);
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagResource);
                if (!item.m_204114_().m_203656_(tagKey)) continue;
                return true;
            }
            if (!itemId.toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FlowerBasketBlockEntity)) {
            return InteractionResult.PASS;
        }
        FlowerBasketBlockEntity flowerBoxBE = (FlowerBasketBlockEntity)blockEntity;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (heldStack.m_41720_() != Items.f_42574_) {
            boolean validFlower = false;
            for (String entry : YAFConfig.flowerBasketItems) {
                if (entry.startsWith("#")) {
                    String tagName = entry.substring(1);
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagName));
                    if (!heldStack.m_204117_(tag)) continue;
                    validFlower = true;
                    break;
                }
                ResourceLocation itemId = Registries.f_256913_.toString().equals(entry) ? null : new ResourceLocation(entry);
                if (itemId == null || !itemId.toString().equals(entry)) continue;
                validFlower = true;
                break;
            }
            if (!validFlower) {
                return InteractionResult.PASS;
            }
        }
        AttachFace attachFace = (AttachFace)state.m_61143_(FACE);
        if (heldStack.m_41720_() == Items.f_42574_) {
            int slot = attachFace == AttachFace.WALL ? BlockPart.get1D(pos, hit.m_82450_(), ((Direction)state.m_61143_((Property)FACING)).m_122427_(), 2) : 0;
            ItemStack flowerStack = flowerBoxBE.getItemFromSlot(slot).m_7968_();
            if (!flowerStack.m_41619_()) {
                flowerBoxBE.removeFlower(slot);
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, flowerStack.m_41777_()));
                level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                heldStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        int slot = attachFace == AttachFace.WALL ? BlockPart.get1D(pos, hit.m_82450_(), ((Direction)state.m_61143_((Property)FACING)).m_122427_(), 2) : 0;
        ItemStack currentFlower = flowerBoxBE.getItemFromSlot(slot).m_7968_();
        if (currentFlower.m_41619_() && heldStack.m_41720_() instanceof BlockItem && this.isAllowedFlower(heldStack.m_41720_())) {
            if (flowerBoxBE.placeFlower(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, slot)) {
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldStack.m_41720_().equals(currentFlower.m_41720_()) && heldStack.m_41720_() instanceof BlockItem && this.isAllowedFlower(heldStack.m_41720_())) {
            flowerBoxBE.removeFlower(slot);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, currentFlower.m_41777_()));
            if (flowerBoxBE.placeFlower(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, slot)) {
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }
}

