/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.SeatBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SofaBlock
extends SeatBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<SofaShape> SHAPE = EnumProperty.m_61587_((String)"shape", SofaShape.class);
    private static final VoxelShape SHAPE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public SofaBlock(@Nullable DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)((Object)SofaShape.SINGLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{FACING, WATERLOGGED, SHAPE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        SofaShape type = (SofaShape)((Object)state.m_61143_(SHAPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return switch (type.ordinal()) {
                    case 4 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.INNER_RIGHT));
                    case 5 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.INNER_LEFT));
                    case 6 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.OUTER_RIGHT));
                    case 7 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.OUTER_LEFT));
                    default -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (type.ordinal()) {
                    case 4 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.INNER_LEFT));
                    case 5 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.INNER_RIGHT));
                    case 6 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.OUTER_RIGHT));
                    case 7 -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)SofaShape.OUTER_LEFT));
                    default -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.m_6943_(state, mirror);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_AABB;
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.4f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos.m_121945_((Direction)state.m_61143_((Property)FACING));
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_();
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)SofaBlock.getConnection(blockState, context.m_43725_(), blockPos)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)SofaBlock.getConnection(state, (Level)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public static SofaShape getConnection(BlockState state, Level level, BlockPos pos) {
        BlockState behindState;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState oppositeState = level.m_8055_(pos.m_121945_(facing));
        if (oppositeState.m_60734_() instanceof SofaBlock && oppositeState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING)) {
            if (oppositeState.m_61143_((Property)FACING) == facing.m_122427_()) {
                return SofaShape.INNER_RIGHT;
            }
            if (oppositeState.m_61143_((Property)FACING) == facing.m_122428_()) {
                return SofaShape.INNER_LEFT;
            }
        }
        if ((behindState = level.m_8055_(pos.m_121945_(facing.m_122424_()))).m_60734_() instanceof SofaBlock && behindState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING)) {
            if (behindState.m_61143_((Property)FACING) == facing.m_122428_()) {
                return SofaShape.OUTER_LEFT;
            }
            if (behindState.m_61143_((Property)FACING) == facing.m_122427_()) {
                return SofaShape.OUTER_RIGHT;
            }
        }
        boolean left = SofaBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122428_());
        boolean right = SofaBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122427_());
        if (left && right) {
            return SofaShape.MIDDLE;
        }
        if (left) {
            return SofaShape.LEFT;
        }
        if (right) {
            return SofaShape.RIGHT;
        }
        return SofaShape.SINGLE;
    }

    public static boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos.m_121945_(direction));
        return state.m_60734_() instanceof SofaBlock;
    }

    public static boolean isDifferentOrientation(BlockState state, Level level, BlockPos pos, Direction dir) {
        BlockState blockState = level.m_8055_(pos.m_121945_(dir));
        return !(blockState.m_60734_() instanceof SofaBlock) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    public static enum SofaShape implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        MIDDLE("middle"),
        RIGHT("right"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private SofaShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

