/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.SpigotBlockEntity;
import com.starfish_studios.yaf.registry.YAFBlockEntities;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpigotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)7.0, (double)10.0, (double)12.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)9.0, (double)12.0, (double)10.0);
    public static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)12.0, (double)9.0);
    public static final VoxelShape WEST_SHAPE = Block.m_49796_((double)7.0, (double)6.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    public static final VoxelShape SHAFT_FLOOR_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
    public static final VoxelShape SHAFT_CEILING_SHAPE = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape NORTH_FLOOR_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)12.0, (double)10.0);
    public static final VoxelShape EAST_FLOOR_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    public static final VoxelShape SOUTH_FLOOR_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)12.0, (double)16.0);
    public static final VoxelShape WEST_FLOOR_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);

    public SpigotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (state.m_61143_(FACE) == AttachFace.CEILING) {
            return SHAFT_CEILING_SHAPE;
        }
        if (state.m_61143_(FACE) == AttachFace.FLOOR) {
            return switch (dir) {
                case Direction.NORTH -> Shapes.m_83113_((VoxelShape)SHAFT_FLOOR_SHAPE, (VoxelShape)NORTH_FLOOR_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                case Direction.EAST -> Shapes.m_83113_((VoxelShape)SHAFT_FLOOR_SHAPE, (VoxelShape)EAST_FLOOR_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                case Direction.SOUTH -> Shapes.m_83113_((VoxelShape)SHAFT_FLOOR_SHAPE, (VoxelShape)SOUTH_FLOOR_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                default -> Shapes.m_83113_((VoxelShape)SHAFT_FLOOR_SHAPE, (VoxelShape)WEST_FLOOR_SHAPE, (BooleanOp)BooleanOp.f_82695_);
            };
        }
        return switch (dir) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        boolean waterOn = (Boolean)blockState.m_61143_((Property)POWERED);
        if (waterOn && player.m_21120_(interactionHand).m_41720_() == Items.f_41902_) {
            player.m_21120_(interactionHand).m_41774_(1);
            player.m_36356_(new ItemStack((ItemLike)Items.f_41903_));
            level.m_5594_(null, blockPos, SoundEvents.f_12546_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (waterOn && player.m_21120_(interactionHand).m_41720_() == Items.f_42446_) {
            player.m_21120_(interactionHand).m_41774_(1);
            player.m_36356_(new ItemStack((ItemLike)Items.f_42447_));
            level.m_5594_(null, blockPos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (waterOn && player.m_21120_(interactionHand).m_41720_() == Items.f_42590_) {
            player.m_21120_(interactionHand).m_41774_(1);
            player.m_36356_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
            level.m_5594_(null, blockPos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            BlockState blockState2 = this.pull(blockState, level, blockPos);
            float f = (Boolean)blockState2.m_61143_((Property)POWERED) != false ? 0.6f : 0.5f;
            level.m_5594_(null, blockPos, waterOn ? (SoundEvent)YAFSoundEvents.SPIGOT_ON.get() : (SoundEvent)YAFSoundEvents.SPIGOT_OFF.get(), SoundSource.BLOCKS, f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState pull(BlockState blockState, Level level, BlockPos blockPos) {
        blockState = (BlockState)blockState.m_61122_((Property)POWERED);
        level.m_7731_(blockPos, blockState, 3);
        return blockState;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)YAFBlockEntities.SPIGOT.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return BaseEntityBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)YAFBlockEntities.SPIGOT.get()), SpigotBlockEntity::fillingTick);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            if (randomSource.m_188500_() < 0.1) {
                double d = (double)pos.m_123341_() + 0.5;
                double e = pos.m_123342_();
                double f = (double)pos.m_123343_() + 0.5;
                level.m_7785_(d, e, f, SoundEvents.f_12540_, SoundSource.BLOCKS, 0.2f, 1.3f, false);
            }
            if (level.m_8055_(pos.m_7495_()).m_60795_() || level.m_8055_(pos.m_7495_()).m_60734_() instanceof CauldronBlock) {
                int i;
                for (i = 0; i < 2; ++i) {
                    x = (double)pos.m_123341_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    y = (double)pos.m_123342_() - 0.4 + (level.f_46441_.m_188500_() * 0.2 - 0.1);
                    z = (double)pos.m_123343_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123804_, x, y, z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 1; ++i) {
                    x = (double)pos.m_123341_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    y = (double)pos.m_123342_() - 0.4 + (level.f_46441_.m_188500_() * 0.2 - 0.1);
                    z = (double)pos.m_123343_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.0, 0.0);
                }
            } else if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof SpongeBlock || level.m_8055_(pos.m_7495_()).m_60734_() instanceof WetSpongeBlock) {
                int i;
                for (i = 0; i < 2; ++i) {
                    x = (double)pos.m_123341_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    y = (double)pos.m_123342_() + 0.2 + (level.f_46441_.m_188500_() * 0.2 - 0.1);
                    z = (double)pos.m_123343_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123804_, x, y, z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 1; ++i) {
                    x = (double)pos.m_123341_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    y = (double)pos.m_123342_() + 0.2 + (level.f_46441_.m_188500_() * 0.2 - 0.1);
                    z = (double)pos.m_123343_() + 0.6 + (level.f_46441_.m_188500_() * 0.25 - 0.25);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
            if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof SimpleWaterloggedBlock && ((Boolean)level.m_8055_(pos.m_7495_()).m_61143_((Property)WATERLOGGED)).booleanValue() || level.m_8055_(pos.m_7495_()).m_60734_() instanceof LayeredCauldronBlock && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_152476_)) {
                double z;
                double y;
                double x;
                int i;
                double yOffset = 0.0;
                int levelBelow = (Integer)level.m_8055_(pos.m_7495_()).m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (level.m_8055_(pos.m_7495_()).m_60734_() instanceof LayeredCauldronBlock) {
                    if (levelBelow == 1) {
                        yOffset = -0.3;
                    } else if (levelBelow == 2) {
                        yOffset = -0.1;
                    } else if (levelBelow == 3) {
                        yOffset = 0.1;
                    }
                }
                if (randomSource.m_188500_() < 0.3) {
                    double d = (double)pos.m_123341_() + 0.5;
                    double e = pos.m_123342_();
                    double f = (double)pos.m_123343_() + 0.5;
                    level.m_7785_(d, e, f, SoundEvents.f_11940_, SoundSource.BLOCKS, 0.02f, 1.0f, false);
                }
                for (i = 0; i < 5; ++i) {
                    x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() * 0.5 - 0.25);
                    y = (double)pos.m_123342_() - 0.1 + yOffset + (level.f_46441_.m_188500_() * 0.2 - 0.1);
                    z = (double)pos.m_123343_() + 0.4 + (level.f_46441_.m_188500_() * 0.5 - 0.25);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 1; ++i) {
                    x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() * 0.5 - 0.25);
                    y = (double)pos.m_123342_() - 0.2 + yOffset + (level.f_46441_.m_188500_() * 0.2 - 0.1);
                    z = (double)pos.m_123343_() + 0.4 + (level.f_46441_.m_188500_() * 0.5 - 0.25);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{FACING, WATERLOGGED, POWERED, FACE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)this.m_49965_().m_61090_();
        Direction direction = context.m_43719_();
        state = direction == Direction.DOWN ? (BlockState)state.m_61124_(FACE, (Comparable)AttachFace.CEILING) : (direction == Direction.UP ? (BlockState)state.m_61124_(FACE, (Comparable)AttachFace.FLOOR) : (BlockState)state.m_61124_(FACE, (Comparable)AttachFace.WALL));
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }
}

