/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block.entity;

import com.starfish_studios.yaf.registry.YAFBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ShelfBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);

    public ShelfBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)YAFBlockEntities.SHELF.get(), blockPos, blockState);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.items, (boolean)true);
        return compoundtag;
    }

    public boolean removeItem(int index, Player player, Level level, boolean removeAll) {
        ItemStack shelfStack = (ItemStack)this.items.get(index);
        if (shelfStack.m_41619_()) {
            return false;
        }
        int removeCount = removeAll ? shelfStack.m_41613_() : 1;
        ItemStack removed = shelfStack.m_41777_();
        removed.m_41764_(removeCount);
        shelfStack.m_41774_(removeCount);
        if (shelfStack.m_41613_() <= 0) {
            this.items.set(index, (Object)ItemStack.f_41583_);
        }
        if (!player.m_36356_(removed.m_41777_())) {
            Containers.m_18992_((Level)level, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)removed);
        }
        this.markUpdated();
        return true;
    }

    public void dropItem(int index, Level level) {
        ItemStack item = ((ItemStack)this.items.get(index)).m_41777_();
        Containers.m_18992_((Level)level, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)item);
        this.items.set(index, (Object)ItemStack.f_41583_);
        this.markUpdated();
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6211_() {
        this.items.clear();
    }
}

