/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.starfish_studios.yaf.block.WindChimeBlock;
import com.starfish_studios.yaf.block.entity.WindChimeBlockEntity;
import com.starfish_studios.yaf.client.model.ChimeBlockEntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class ChimeBlockEntityRenderer
implements BlockEntityRenderer<WindChimeBlockEntity> {
    ChimeBlockEntityModel model;

    public ChimeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ChimeBlockEntityModel(context.m_173582_(ChimeBlockEntityModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(WindChimeBlockEntity entity) {
        String material = ((WindChimeBlock)entity.m_58900_().m_60734_()).material;
        return new ResourceLocation("yaf", "textures/block/wind_chime/" + material + "_wind_chimes_world.png");
    }

    public void render(WindChimeBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        float animFactor = blockEntity.getAnimationFactor();
        float baseSwingAngleX = blockEntity.getBaseSwingAngleX(partialTick) * animFactor + blockEntity.getIdleBaseSwingAngleX(partialTick) * (1.0f - animFactor);
        float baseSwingAngleZ = blockEntity.getBaseSwingAngleZ(partialTick) * animFactor + blockEntity.getIdleBaseSwingAngleZ(partialTick) * (1.0f - animFactor);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(blockEntity)));
        this.model.base.f_104203_ = (float)Math.toRadians(baseSwingAngleX * 15.0f * animFactor);
        this.model.base.f_104205_ = (float)Math.toRadians(baseSwingAngleZ * 15.0f * animFactor);
        for (int i = 0; i < 4; ++i) {
            float chimeAngle = blockEntity.getChimeSwingAngleX(i, partialTick) * animFactor + blockEntity.getIdleChimeSwingAngleX(i, partialTick) * (1.0f - animFactor);
            this.model.getChimeBound((int)(i + 1)).f_104203_ = (float)Math.toRadians(chimeAngle);
            this.model.getChime((int)(i + 1)).f_104203_ = (float)Math.toRadians(chimeAngle);
            float chimeAngleZ = blockEntity.getChimeSwingAngleZ(i, partialTick) * animFactor + blockEntity.getIdleChimeSwingAngleZ(i, partialTick) * (1.0f - animFactor);
            this.model.getChimeBound((int)(i + 1)).f_104205_ = (float)Math.toRadians(chimeAngleZ);
            this.model.getChime((int)(i + 1)).f_104205_ = (float)Math.toRadians(chimeAngleZ);
        }
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

