/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.starfish_studios.yaf.block.entity.TableBlockEntity;
import com.starfish_studios.yaf.block.properties.ColorList;
import com.starfish_studios.yaf.client.model.TableBlockEntityModel;
import com.starfish_studios.yaf.client.model.TableclothModel;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class TableBlockEntityRenderer
implements BlockEntityRenderer<TableBlockEntity> {
    private final TableBlockEntityModel model;
    private final TableclothModel cloth;
    private final float oy;

    public TableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new TableBlockEntityModel(context.m_173582_(TableBlockEntityModel.LAYER_LOCATION));
        this.cloth = new TableclothModel(context.m_173582_(TableclothModel.LAYER_LOCATION));
        this.oy = this.model.top.f_104201_;
    }

    public void render(TableBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean leg1 = blockEntity.hasLeg(1);
        boolean leg2 = blockEntity.hasLeg(2);
        boolean leg3 = blockEntity.hasLeg(3);
        boolean leg4 = blockEntity.hasLeg(4);
        boolean isShort = blockEntity.isShort();
        this.model.leg1.f_104207_ = leg1 && !isShort;
        this.model.leg2.f_104207_ = leg2 && !isShort;
        this.model.leg3.f_104207_ = leg3 && !isShort;
        this.model.leg4.f_104207_ = leg4 && !isShort;
        this.model.small1.f_104207_ = leg1 && isShort;
        this.model.small2.f_104207_ = leg2 && isShort;
        this.model.small3.f_104207_ = leg3 && isShort;
        this.model.small4.f_104207_ = leg4 && isShort;
        float shortY = isShort ? 8.0f : 0.0f;
        this.model.top.f_104201_ = this.oy + shortY;
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(blockEntity)));
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (blockEntity.getColor() != ColorList.EMPTY) {
            VertexConsumer clothConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getClothTextureLocation(blockEntity)));
            poseStack.m_85837_(0.0, (double)(shortY / 16.0f), 0.0);
            this.cloth.m_7695_(poseStack, clothConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    private ResourceLocation getTextureLocation(TableBlockEntity blockEntity) {
        Block state = blockEntity.m_58900_().m_60734_();
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)state).m_135815_();
        return new ResourceLocation("yaf", "textures/entity/table/" + name + ".png");
    }

    private ResourceLocation getClothTextureLocation(TableBlockEntity blockEntity) {
        String name = blockEntity.getColor().m_7912_().toLowerCase(Locale.ROOT);
        return new ResourceLocation("yaf", "textures/entity/table/" + name + "_tablecloth.png");
    }
}

