/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.world;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class YAFSavedData
extends SavedData {
    public final List<MailboxData> mailboxes = new ArrayList<MailboxData>();

    public static YAFSavedData load(CompoundTag nbt) {
        YAFSavedData data = new YAFSavedData();
        ListTag mailboxesTag = nbt.m_128437_("Mailboxes", 10);
        for (int i = 0; i < mailboxesTag.size(); ++i) {
            CompoundTag mailNbt = mailboxesTag.m_128728_(i);
            String name = mailNbt.m_128461_("Name");
            String playerName = mailNbt.m_128461_("PlayerName");
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)mailNbt.m_128469_("GlobalPos"));
            Optional dim = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)mailNbt.m_128423_("MailboxDimension")).result();
            if (!dim.isPresent()) continue;
            MailboxData newPair = new MailboxData(playerName, name, GlobalPos.m_122643_((ResourceKey)((ResourceKey)dim.get()), (BlockPos)pos));
            data.mailboxes.add(newPair);
        }
        return data;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag nbtList = new ListTag();
        for (MailboxData mailbox : this.mailboxes) {
            CompoundTag mailNbt = new CompoundTag();
            mailNbt.m_128359_("Name", mailbox.name());
            mailNbt.m_128359_("PlayerName", mailbox.playerName());
            mailNbt.m_128365_("GlobalPos", (Tag)NbtUtils.m_129224_((BlockPos)mailbox.globalPos.m_122646_()));
            DataResult result = Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)mailbox.globalPos.m_122640_());
            result.result().ifPresent(tag -> mailNbt.m_128365_("MailboxDimension", tag));
            nbtList.add((Object)mailNbt);
        }
        nbt.m_128365_("Mailboxes", (Tag)nbtList);
        return nbt;
    }

    public static YAFSavedData getMailboxes(ServerLevel level) {
        return (YAFSavedData)level.m_7654_().m_129783_().m_8895_().m_164861_(YAFSavedData::load, YAFSavedData::new, "yaf");
    }

    public record MailboxData(String playerName, String name, GlobalPos globalPos) {
    }
}

