/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.AllSoundEvents;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlock;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class AndesiteDepositorBlock
extends AbstractDepositorBlock<AndesiteDepositorBlockEntity> {
    public AndesiteDepositorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<AndesiteDepositorBlockEntity> getBlockEntityClass() {
        return AndesiteDepositorBlockEntity.class;
    }

    public BlockEntityType<AndesiteDepositorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.ANDESITE_DEPOSITOR.get();
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (hit.m_82434_().m_122434_().m_122478_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.isTrusted(player, (BlockGetter)level, pos)) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> Utils.openScreen((ServerPlayer)player, be, arg_0 -> ((AndesiteDepositorBlockEntity)be).sendToMenu(arg_0)));
            }
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_((Property)HORIZONTAL_FACING) != hit.m_82434_()) {
            return InteractionResult.PASS;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() || ((Boolean)state.m_61143_((Property)LOCKED)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AndesiteDepositorBlockEntity) {
            AndesiteDepositorBlockEntity andesiteDepositor = (AndesiteDepositorBlockEntity)blockEntity;
            Coin coin = andesiteDepositor.getCoin();
            ItemStack handStack = player.m_21120_(hand);
            if (NumismaticsTags.AllItemTags.CARDS.matches(handStack)) {
                UUID id;
                BankAccount account;
                if (CardItem.isBound(handStack) && (account = Numismatics.BANK.getAccount(id = CardItem.get(handStack))) != null && account.isAuthorized(player) && account.deduct(coin, 1)) {
                    this.activate(state, level, pos);
                    andesiteDepositor.addCoin(coin, 1);
                }
            } else if (CoinItem.extract(player, hand, coin, true)) {
                this.activate(state, level, pos);
                andesiteDepositor.addCoin(coin, 1);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"gui.numismatics.vendor.insufficient_funds").m_130940_(ChatFormatting.DARK_RED), true);
                level.m_5594_(null, pos, AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        return InteractionResult.CONSUME;
    }
}

