/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item;

import java.util.List;
import joptsimple.internal.Strings;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.compat.Modid;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IConfigured
extends ItemLike {
    @NotNull
    default public Modid[] getModid() {
        return Util.EMPTY;
    }

    @NotNull
    default public Modid[] getConflicts() {
        return Util.EMPTY;
    }

    default public boolean hasConflict() {
        return this.getConflicts().length > 0 && Mods.loaded(Mods.Strategy.OR, this.getConflicts());
    }

    @Nullable
    default public TagKey<Item> getDependencyTag() {
        return null;
    }

    default public boolean isDependencyTag() {
        return Util.tagPopulated(this.getDependencyTag());
    }

    @Nullable
    default public TagKey<Item> getEmptyTag() {
        return null;
    }

    default public boolean isEmptyTag() {
        return Util.tagEmpty(this.getEmptyTag());
    }

    default public boolean isLoaded() {
        Modid[] dependencies = this.getModid();
        return dependencies.length < 1 || Mods.loaded(this.getStrategy(), dependencies);
    }

    default public boolean enabled() {
        return Util.configEnabled(this.m_5456_()) && this.isLoaded() && !this.hasConflict() && this.isDependencyTag() && this.isEmptyTag();
    }

    default public boolean enabledText(List<Component> comps) {
        if (!this.enabled()) {
            comps.add((Component)Util.tooltip("disabled").m_130940_(ChatFormatting.UNDERLINE));
            if (!this.isLoaded() && this.getModid().length > 0) {
                comps.add((Component)Util.tooltip("requires_modid"));
                comps.add((Component)Component.m_237113_((String)Strings.join((String[])Mods.names(this.getModid()), (String)", ")).m_130940_(ChatFormatting.UNDERLINE));
            }
            if (!this.isDependencyTag() && this.getDependencyTag() != null) {
                comps.add((Component)Util.tooltip("requires_tag"));
                comps.add((Component)Util.tagComponent(this.getDependencyTag()).m_130940_(ChatFormatting.UNDERLINE));
            }
            if (!this.isEmptyTag() && this.getEmptyTag() != null) {
                comps.add((Component)Util.tooltip("requires_empty_tag"));
                comps.add((Component)Util.tagComponent(this.getEmptyTag()).m_130940_(ChatFormatting.UNDERLINE));
            }
            return false;
        }
        return true;
    }

    default public Mods.Strategy getStrategy() {
        return Mods.Strategy.OR;
    }
}

