/*
 * Decompiled with CFR 0.152.
 */
package snownee.drawer.client;

import com.jaquadro.minecraft.storagedrawers.client.gui.StorageGuiGraphics;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import snownee.drawer.Config;
import snownee.drawer.client.TooltipEvents;

public class ClientDrawerTooltip
implements TooltipComponent,
ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");
    private final List<Object2IntMap.Entry<ItemStack>> contents;

    public ClientDrawerTooltip(List<Object2IntMap.Entry<ItemStack>> contents) {
        this.contents = contents;
    }

    public int m_142103_() {
        return 26;
    }

    public int m_142069_(Font p_169952_) {
        return this.contents.size() * 18 + 2;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics guiGraphics) {
        int i = this.contents.size();
        int j = 1;
        boolean flag = false;
        int k = 0;
        StorageGuiGraphics itemRenderer = TooltipEvents.storageItemRender;
        itemRenderer.m_280168_().m_85836_();
        itemRenderer.m_280168_().m_252931_(guiGraphics.m_280168_().m_85850_().m_252922_());
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = x + i1 * 18 + 1;
                int k1 = y + l * 20 + 1;
                this.renderSlot(j1, k1, k++, flag, font, guiGraphics, itemRenderer);
            }
        }
        if (Config.drawBorder) {
            this.drawBorder(x, y, i, j, guiGraphics);
        }
        itemRenderer.m_280168_().m_85849_();
    }

    private void renderSlot(int x, int y, int slot, boolean p_194030_, Font font, GuiGraphics poseStack, StorageGuiGraphics itemRenderer) {
        if (slot >= this.contents.size()) {
            if (Config.drawSlot) {
                this.blit(poseStack, x, y, p_194030_ ? Texture.BLOCKED_SLOT : Texture.SLOT);
            }
        } else {
            Object2IntMap.Entry<ItemStack> entry = this.contents.get(slot);
            ItemStack itemstack = (ItemStack)entry.getKey();
            itemstack.m_41764_(entry.getIntValue());
            if (Config.drawSlot) {
                this.blit(poseStack, x, y, Texture.SLOT);
            }
            itemRenderer.overrideStack = itemstack;
            itemRenderer.m_280256_(itemstack, x + 1, y + 1, slot);
            itemRenderer.m_280302_(font, itemstack, x + 1, y + 1, null);
        }
    }

    private void drawBorder(int p_194020_, int p_194021_, int p_194022_, int p_194023_, GuiGraphics p_194024_) {
        this.blit(p_194024_, p_194020_, p_194021_, Texture.BORDER_CORNER_TOP);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_, Texture.BORDER_CORNER_TOP);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, p_194020_ + 1 + i * 18, p_194021_, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(p_194024_, p_194020_ + 1 + i * 18, p_194021_ + p_194023_ * 20, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, p_194020_, p_194021_ + j * 20 + 1, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_ + j * 20 + 1, Texture.BORDER_VERTICAL);
        }
        this.blit(p_194024_, p_194020_, p_194021_ + p_194023_ * 20, Texture.BORDER_CORNER_BOTTOM);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_ + p_194023_ * 20, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(GuiGraphics p_281273_, int p_282428_, int p_281897_, Texture p_281917_) {
        p_281273_.m_280398_(TEXTURE_LOCATION, p_282428_, p_281897_, 0, (float)p_281917_.x, (float)p_281917_.y, p_281917_.w, p_281917_.h, 128, 128);
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

