/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.capability;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidDrawerControllerSave
extends SavedData {
    private final Map<BlockPos, FluidStack> chunkPosData = new HashMap<BlockPos, FluidStack>();

    public FluidDrawerControllerSave() {
    }

    public FluidDrawerControllerSave(CompoundTag tag) {
        ListTag list = tag.m_128437_("fluid", 10);
        for (Tag t : list) {
            CompoundTag manaTag = (CompoundTag)t;
            BlockPos chunkPos = new BlockPos(manaTag.m_128451_("x"), manaTag.m_128451_("y"), manaTag.m_128451_("z"));
            this.chunkPosData.put(chunkPos, FluidStack.loadFluidStackFromNBT((CompoundTag)manaTag));
        }
    }

    public void update(BlockPos blockPos, FluidStack fluid) {
        this.chunkPosData.put(blockPos, fluid);
        this.m_77762_();
    }

    public FluidStack get(BlockPos blockPos) {
        return this.chunkPosData.getOrDefault(blockPos, FluidStack.EMPTY);
    }

    public void remove(BlockPos blockPos) {
        this.chunkPosData.remove(blockPos);
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.chunkPosData.forEach((chunkPos, mana) -> {
            CompoundTag manaTag = new CompoundTag();
            manaTag.m_128405_("x", chunkPos.m_123341_());
            manaTag.m_128405_("y", chunkPos.m_123342_());
            manaTag.m_128405_("z", chunkPos.m_123343_());
            mana.writeToNBT(manaTag);
            list.add((Object)manaTag);
        });
        tag.m_128365_("fluid", (Tag)list);
        return tag;
    }

    public static FluidDrawerControllerSave get(Level worldIn) {
        if (!(worldIn instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel world = (ServerLevel)worldIn;
        DimensionDataStorage storage = world.m_8895_();
        return (FluidDrawerControllerSave)storage.m_164861_(FluidDrawerControllerSave::new, FluidDrawerControllerSave::new, "fluid");
    }
}

