/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.placement.ParsedProtoTag;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.PlaceTarget;
import snownee.kiwi.customization.placement.StatePropertiesPredicate;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.Util;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record PlaceSlotProvider(List<PlaceTarget> target, Optional<String> transformWith, List<String> tag, List<Slot> slots) {
    public static final Predicate<String> TAG_PATTERN = Pattern.compile("^[*@]?(?:[a-z0-9_/.]+:)?[a-z0-9_/.]+$").asPredicate();
    public static final Codec<String> TAG_CODEC = ExtraCodecs.m_264370_((Codec)Codec.STRING, s -> {
        if (TAG_PATTERN.test((String)s)) {
            return DataResult.success((Object)s);
        }
        return DataResult.error(() -> "Bad tag format: " + s);
    });
    public static final Codec<PlaceSlotProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.compactList(PlaceTarget.CODEC).fieldOf("target").forGetter(PlaceSlotProvider::target), (App)CustomizationCodecs.strictOptionalField(Codec.STRING, "transform_with").forGetter(PlaceSlotProvider::transformWith), (App)CustomizationCodecs.strictOptionalField(TAG_CODEC.listOf(), "tag", List.of()).forGetter(PlaceSlotProvider::tag), (App)Slot.CODEC.listOf().fieldOf("slots").forGetter(PlaceSlotProvider::slots)).apply((Applicative)instance, PlaceSlotProvider::new));

    private void attachSlots(Preparation preparation, Block block) {
        for (Slot slot : this.slots) {
            for (BlockState blockState : block.m_49965_().m_61056_()) {
                if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || !slot.when.isEmpty() && slot.when.stream().noneMatch(predicate -> predicate.test(blockState))) continue;
                for (Direction direction : Util.DIRECTIONS) {
                    Side side = slot.sides.get(direction);
                    if (side == null) continue;
                    PlaceSlot placeSlot = new PlaceSlot(direction, this.generateTags(slot, side, blockState, Rotation.NONE));
                    preparation.register(blockState, placeSlot);
                }
                String transformWith = (slot.transformWith.isPresent() ? slot.transformWith : this.transformWith).orElse("none");
                if ("none".equals(transformWith)) continue;
                Property<?> property = KBlockUtils.getProperty(blockState, transformWith);
                if (!(property instanceof DirectionProperty)) {
                    throw new IllegalArgumentException("Invalid transform_with property: " + transformWith);
                }
                DirectionProperty directionProperty = (DirectionProperty)property;
                this.attachSlotWithTransformation(preparation, slot, blockState, directionProperty);
            }
        }
    }

    private void attachSlotWithTransformation(Preparation preparation, Slot slot, BlockState blockState, DirectionProperty property) {
        Direction baseDirection = (Direction)blockState.m_61143_((Property)property);
        BlockState rotatedState = blockState;
        while ((rotatedState = (BlockState)rotatedState.m_61122_((Property)property)) != blockState) {
            Direction newDirection = (Direction)rotatedState.m_61143_((Property)property);
            if (Direction.Plane.VERTICAL.test(newDirection)) continue;
            Rotation rotation = null;
            for (Rotation value : Rotation.values()) {
                if (value.m_55954_(baseDirection) != newDirection) continue;
                rotation = value;
                break;
            }
            if (rotation == null) {
                throw new IllegalStateException("Invalid direction: " + newDirection);
            }
            for (Direction direction : Util.DIRECTIONS) {
                Side side = slot.sides.get(direction);
                if (side == null) continue;
                PlaceSlot placeSlot = new PlaceSlot(rotation.m_55954_(direction), this.generateTags(slot, side, rotatedState, rotation));
                preparation.register(rotatedState, placeSlot);
            }
        }
    }

    private ImmutableSortedMap<String, String> generateTags(Slot slot, Side side, BlockState rotatedState, Rotation rotation) {
        HashMap map = Maps.newHashMap();
        MutableObject primaryKey = new MutableObject();
        Streams.concat((Stream[])new Stream[]{this.tag.stream(), slot.tag.stream(), side.tag.stream()}).forEach(s -> {
            ParsedProtoTag tag = ParsedProtoTag.of(s).resolve(rotatedState, rotation);
            if (tag.prefix().equals("*")) {
                if (primaryKey.getValue() == null) {
                    primaryKey.setValue((Object)tag.key());
                } else if (!Objects.equals(primaryKey.getValue(), tag.key())) {
                    throw new IllegalArgumentException("Only one primary tag is allowed");
                }
            }
            map.put(tag.key(), tag.value());
        });
        if (primaryKey.getValue() == null) {
            throw new IllegalArgumentException("Primary tag is required");
        }
        String primaryValue = (String)map.get(primaryKey.getValue());
        map.remove(primaryKey.getValue());
        if (primaryValue.isEmpty()) {
            map.put("*%s".formatted(primaryKey.getValue()), "");
        } else {
            map.put("*%s:%s".formatted(primaryKey.getValue(), primaryValue), "");
        }
        return ImmutableSortedMap.copyOf((Map)map, PlaceSlot.TAG_COMPARATOR);
    }

    public record Slot(List<StatePropertiesPredicate> when, Optional<String> transformWith, List<String> tag, Map<Direction, Side> sides) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(ExtraCodecs.m_144637_(CustomizationCodecs.compactList(StatePropertiesPredicate.CODEC)), "when", List.of()).forGetter(Slot::when), (App)CustomizationCodecs.strictOptionalField(Codec.STRING, "transform_with").forGetter(Slot::transformWith), (App)CustomizationCodecs.strictOptionalField(TAG_CODEC.listOf(), "tag", List.of()).forGetter(Slot::tag), (App)Codec.unboundedMap(CustomizationCodecs.DIRECTION, Side.CODEC).xmap(Map::copyOf, Function.identity()).fieldOf("sides").forGetter(Slot::sides)).apply((Applicative)instance, Slot::new));
    }

    public record Side(List<String> tag) {
        public static final Codec<Side> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(TAG_CODEC.listOf(), "tag", List.of()).forGetter(Side::tag)).apply((Applicative)instance, Side::new));
    }

    public record Preparation(Map<ResourceLocation, PlaceSlotProvider> providers, ListMultimap<KBlockTemplate, KHolder<PlaceSlotProvider>> byTemplate, ListMultimap<ResourceLocation, KHolder<PlaceSlotProvider>> byBlock, ListMultimap<Pair<BlockState, Direction>, PlaceSlot> slots, Interner<PlaceSlot> slotInterner, Set<Block> accessedBlocks, Set<String> knownPrimaryTags) {
        public static Preparation of(Supplier<Map<ResourceLocation, PlaceSlotProvider>> providersSupplier, Map<ResourceLocation, KBlockTemplate> templates) {
            Map<ResourceLocation, PlaceSlotProvider> providers = Platform.isDataGen() ? Map.of() : providersSupplier.get();
            ArrayListMultimap byTemplate = ArrayListMultimap.create();
            ArrayListMultimap byBlock = ArrayListMultimap.create();
            for (Map.Entry entry : providers.entrySet()) {
                KHolder<PlaceSlotProvider> holder = new KHolder<PlaceSlotProvider>((ResourceLocation)entry.getKey(), (PlaceSlotProvider)entry.getValue());
                for (PlaceTarget target : holder.value().target) {
                    switch (target.type()) {
                        case TEMPLATE: {
                            KBlockTemplate template = templates.get(target.id());
                            if (template == null) {
                                Kiwi.LOGGER.error("Template {} not found for slot provider {}", (Object)target.id(), holder);
                                break;
                            }
                            byTemplate.put((Object)template, holder);
                            break;
                        }
                        case BLOCK: {
                            byBlock.put((Object)target.id(), holder);
                        }
                    }
                }
            }
            return new Preparation(providers, (ListMultimap<KBlockTemplate, KHolder<PlaceSlotProvider>>)byTemplate, (ListMultimap<ResourceLocation, KHolder<PlaceSlotProvider>>)byBlock, (ListMultimap<Pair<BlockState, Direction>, PlaceSlot>)ArrayListMultimap.create(), (Interner<PlaceSlot>)Interners.newStrongInterner(), Sets.newHashSet(), Sets.newHashSet());
        }

        public void attachSlotsA(Block block, KBlockDefinition definition) {
            if (!this.accessedBlocks.add(block)) {
                return;
            }
            for (KHolder holder : this.byTemplate.get((Object)definition.template().template())) {
                try {
                    ((PlaceSlotProvider)holder.value()).attachSlots(this, block);
                }
                catch (Exception e) {
                    Kiwi.LOGGER.error("Failed to attach slots for block %s with provider %s".formatted(block, holder), (Throwable)e);
                }
            }
        }

        public void attachSlotsB() {
            this.byBlock.asMap().forEach((blockId, holders) -> {
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
                if (block == Blocks.f_50016_) {
                    Kiwi.LOGGER.error("Block %s not found for slot providers %s".formatted(blockId, holders));
                    return;
                }
                for (KHolder holder : holders) {
                    try {
                        ((PlaceSlotProvider)holder.value()).attachSlots(this, block);
                    }
                    catch (Exception e) {
                        Kiwi.LOGGER.error("Failed to attach slots for block %s with provider %s".formatted(block, holder), (Throwable)e);
                    }
                }
            });
            PlaceSlot.renewData(this);
        }

        public void register(BlockState blockState, PlaceSlot placeSlot) {
            if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                throw new IllegalArgumentException("Waterlogged block state is not supported: %s".formatted(blockState));
            }
            Pair key = Pair.of((Object)blockState, (Object)placeSlot.side());
            List slots = this.slots().get((Object)key);
            if (!slots.isEmpty()) {
                String primaryTag = placeSlot.primaryTag();
                Optional<PlaceSlot> any = slots.stream().filter(slot -> slot.primaryTag().equals(primaryTag)).findAny();
                if (any.isPresent()) {
                    throw new IllegalArgumentException("Primary tag %s conflict: %s and %s".formatted(primaryTag, placeSlot, any.get()));
                }
            }
            placeSlot = (PlaceSlot)this.slotInterner.intern((Object)placeSlot);
            this.slots().put((Object)key, (Object)placeSlot);
            this.knownPrimaryTags().add(placeSlot.primaryTag());
        }
    }
}

