/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.treedecorators.BWGTreeDecorators;
import org.jetbrains.annotations.NotNull;

public class GlowBerryDecorator
extends TreeDecorator {
    public static final Codec<GlowBerryDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FloatProvider.f_146502_.fieldOf("probability").forGetter(glowBerryDecorator -> glowBerryDecorator.probability), (App)IntProvider.f_146531_.fieldOf("length").forGetter(glowBerryDecorator -> glowBerryDecorator.length), (App)FloatProvider.f_146502_.fieldOf("berries_probability").forGetter(glowBerryDecorator -> glowBerryDecorator.berriesProbability)).apply((Applicative)instance, GlowBerryDecorator::new));
    private final FloatProvider probability;
    private final IntProvider length;
    private final FloatProvider berriesProbability;

    public GlowBerryDecorator(FloatProvider probability, IntProvider length, FloatProvider berriesProbability) {
        this.probability = probability;
        this.length = length;
        this.berriesProbability = berriesProbability;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return BWGTreeDecorators.GLOW_BERRY_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        float probability = this.probability.m_214084_(random);
        int lengthSample = this.length.m_214085_(random);
        float berriesProbability = this.berriesProbability.m_214084_(random);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        block0: for (BlockPos log : context.m_226068_()) {
            if (!(random.m_188501_() < probability)) continue;
            mutable.m_122190_((Vec3i)log).m_122173_(Direction.DOWN);
            if (!context.m_226059_((BlockPos)mutable) || !context.m_226059_((BlockPos)mutable.m_122173_(Direction.DOWN))) continue;
            mutable.m_122173_(Direction.UP);
            boolean shouldBreak = false;
            for (int i = 1; i <= lengthSample; ++i) {
                BlockState state;
                if (context.m_226059_(mutable.m_7918_(0, -1, 0)) && context.m_226059_(mutable.m_7918_(0, -2, 0))) {
                    state = i == lengthSample ? Blocks.f_152538_.m_49966_() : Blocks.f_152539_.m_49966_();
                } else {
                    state = Blocks.f_152538_.m_49966_();
                    shouldBreak = true;
                }
                float chance = random.m_188501_();
                boolean value = chance < berriesProbability;
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_155977_, (Comparable)Boolean.valueOf(value));
                if (state.m_61138_((Property)BlockStateProperties.f_61411_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61411_, (Comparable)Integer.valueOf(Mth.m_216287_((RandomSource)random, (int)0, (int)25)));
                }
                context.m_226061_((BlockPos)mutable, state);
                if (shouldBreak) continue block0;
                mutable.m_122173_(Direction.DOWN);
            }
        }
    }
}

