/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class NiterGlassBlock
extends AbstractGlassBlock {
    public static final BooleanProperty TRANSPARENT = BooleanProperty.m_61465_((String)"transparent");

    public NiterGlassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TRANSPARENT, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TRANSPARENT});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_) {
            boolean isPowered = world.m_276867_(pos);
            if ((Boolean)state.m_61143_((Property)TRANSPARENT) != isPowered) {
                this.updateStateAndNeighbors(world, pos, state, isPowered);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isPowered = context.m_43725_().m_276867_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)TRANSPARENT, (Comparable)Boolean.valueOf(isPowered));
    }

    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction direction) {
        if (adjacentState.m_60713_((Block)this)) {
            return true;
        }
        return super.m_6104_(state, adjacentState, direction);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)TRANSPARENT);
    }

    public int m_7753_(BlockState state, @NotNull BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)TRANSPARENT) != false ? 0 : world.m_7469_();
    }

    private void updateStateAndNeighbors(Level world, BlockPos pos, BlockState initialState, boolean isPowered) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(pos);
        visited.add(pos);
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = world.m_8055_(currentPos);
            if ((Boolean)currentState.m_61143_((Property)TRANSPARENT) != isPowered) {
                BlockState newState = (BlockState)currentState.m_61124_((Property)TRANSPARENT, (Comparable)Boolean.valueOf(isPowered));
                world.m_7731_(currentPos, newState, 2);
            }
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = currentPos.m_121945_(direction);
                if (visited.contains(neighborPos) || !(world.m_8055_(neighborPos).m_60734_() instanceof NiterGlassBlock)) continue;
                queue.add(neighborPos);
                visited.add(neighborPos);
            }
        }
    }
}

