/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.render.entity.BeamRenderer;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;

@OnlyIn(value=Dist.CLIENT)
public class BeamHandler {
    public static final Map<UUID, BeamInfo> activeBeams = new HashMap<UUID, BeamInfo>();
    private static final float SMOOTHING_FACTOR = 0.3f;
    private static final float INITIAL_SMOOTHING_FACTOR = 0.6f;
    private static final long CONTINUOUS_BEAM_DURATION_MS = 200L;
    private static final long SEMI_BEAM_DURATION_MS = 50L;
    private static final long CLEANUP_DELAY_MS = 50L;

    public static float[] getBeamColorForWeapon(ItemStack heldItem, Gun modifiedGun) {
        boolean isEnchanted = heldItem.m_41793_();
        String primaryColorHex = isEnchanted && modifiedGun.getGeneral().getEnchantedBeamColor() != null ? modifiedGun.getGeneral().getEnchantedBeamColor() : modifiedGun.getGeneral().getBeamColor();
        String secondaryColorHex = isEnchanted && modifiedGun.getGeneral().getEnchantedSecondaryBeamColor() != null ? modifiedGun.getGeneral().getEnchantedSecondaryBeamColor() : modifiedGun.getGeneral().getSecondaryBeamColor();
        float[] primaryColor = BeamHandler.parseBeamColor(primaryColorHex);
        float[] secondaryColor = BeamHandler.parseBeamColor(secondaryColorHex);
        assert (Minecraft.m_91087_().f_91073_ != null);
        float time = ((float)Minecraft.m_91087_().f_91073_.m_46467_() + Minecraft.m_91087_().m_91296_()) % 100.0f;
        float progress = (Mth.m_14031_((float)((float)((double)time / 100.0 * Math.PI * 2.0))) + 1.0f) / 2.0f;
        return BeamHandler.interpolateColors(primaryColor, secondaryColor, progress);
    }

    public static void stopBeam(UUID playerId) {
        BeamInfo beamInfo = activeBeams.get(playerId);
        if (beamInfo != null) {
            beamInfo.isBeamActive = false;
            long duration = beamInfo.isBeamFireMode ? 200L : 50L;
            beamInfo.expiryTime = System.currentTimeMillis() + duration;
        }
    }

    private static void cleanupInactiveBeams() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, BeamInfo>> iterator = activeBeams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, BeamInfo> entry = iterator.next();
            BeamInfo beamInfo = entry.getValue();
            if ((beamInfo.isBeamActive || currentTime <= beamInfo.expiryTime + 50L) && currentTime - beamInfo.lastUpdateTime <= 500L) continue;
            iterator.remove();
        }
    }

    public static void updateBeam(UUID playerId, Vec3 startPos, Vec3 endPos) {
        BeamInfo beamInfo = activeBeams.get(playerId);
        if (beamInfo != null) {
            beamInfo.updatePositions(startPos, endPos);
            beamInfo.isBeamActive = true;
        } else {
            GunItem gunItem;
            Gun modifiedGun;
            ItemStack heldItem;
            Item item;
            assert (Minecraft.m_91087_().f_91073_ != null);
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(playerId);
            boolean isBeamFireMode = false;
            if (player != null && (item = (heldItem = player.m_21205_()).m_41720_()) instanceof GunItem && (modifiedGun = (gunItem = (GunItem)item).getModifiedGun(heldItem)) != null) {
                isBeamFireMode = modifiedGun.getGeneral().getFireMode().equals(FireMode.BEAM);
            }
            BeamInfo newBeamInfo = new BeamInfo(startPos, endPos, System.currentTimeMillis(), isBeamFireMode);
            newBeamInfo.isBeamActive = true;
            activeBeams.put(playerId, newBeamInfo);
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        BeamHandler.cleanupInactiveBeams();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        BeamHandler.setupRenderContext(poseStack, event.getPartialTick(), player);
        BeamHandler.renderActiveBeams(mc, event.getPartialTick(), poseStack, bufferSource);
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    private static void setupRenderContext(PoseStack poseStack, float partialTicks, LocalPlayer player) {
        GunItem gunItem;
        Gun modifiedGun;
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem && (modifiedGun = (gunItem = (GunItem)item).getModifiedGun(heldItem)) != null && modifiedGun.getGeneral().getFireMode().equals(FireMode.BEAM)) {
            player.f_36100_ = 0.0f;
            player.f_36099_ = 0.0f;
            player.f_19787_ = 0.0f;
            player.f_19867_ = 0.0f;
        }
        Vec3 renderPos = BeamHandler.calculateBasePosition((Player)player, partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_(-renderPos.f_82479_, -renderPos.f_82480_, -renderPos.f_82481_);
    }

    private static void renderActiveBeams(Minecraft mc, float partialTicks, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        activeBeams.forEach((uuid, beamInfo) -> {
            if (!BeamHandler.shouldRenderBeam(beamInfo)) {
                return;
            }
            assert (mc.f_91073_ != null);
            Player beamPlayer = mc.f_91073_.m_46003_(uuid);
            if (beamPlayer == null || beamPlayer.m_213877_()) {
                return;
            }
            ItemStack heldItem = beamPlayer.m_21205_();
            Item patt6505$temp = heldItem.m_41720_();
            if (!(patt6505$temp instanceof GunItem)) {
                return;
            }
            GunItem gunItem = (GunItem)patt6505$temp;
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (modifiedGun == null) {
                return;
            }
            BeamHandler.renderBeam(beamPlayer, beamInfo, modifiedGun, heldItem, partialTicks, poseStack, bufferSource);
        });
    }

    private static boolean shouldRenderBeam(BeamInfo beamInfo) {
        return beamInfo.isBeamActive || System.currentTimeMillis() <= beamInfo.expiryTime;
    }

    private static void renderBeam(Player beamPlayer, BeamInfo beamInfo, Gun modifiedGun, ItemStack heldItem, float partialTicks, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        Vec3 beamOrigin;
        float originalBob = beamPlayer.f_36100_;
        float originalOBob = beamPlayer.f_36099_;
        float originalWalkDist = beamPlayer.f_19787_;
        float originalWalkDistO = beamPlayer.f_19867_;
        if (heldItem.m_41720_() instanceof GunItem && ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem).getGeneral().getFireMode().equals(FireMode.BEAM)) {
            beamPlayer.f_36100_ = 0.0f;
            beamPlayer.f_36099_ = 0.0f;
            beamPlayer.f_19787_ = 0.0f;
            beamPlayer.f_19867_ = 0.0f;
        }
        float[] interpolatedColor = BeamHandler.getBeamColorForWeapon(heldItem, modifiedGun);
        float smoothingFactor = System.currentTimeMillis() - beamInfo.startTime < 100L ? 0.6f : 0.3f;
        beamInfo.smoothedStartPos = beamOrigin = BeamHandler.calculateBeamOrigin(beamPlayer, modifiedGun, partialTicks);
        Vec3 lookVec = Vec3.m_82498_((float)Mth.m_14179_((float)partialTicks, (float)beamPlayer.f_19860_, (float)beamPlayer.m_146909_()), (float)Mth.m_14179_((float)partialTicks, (float)beamPlayer.f_19859_, (float)beamPlayer.m_146908_()));
        Vec3 targetEndPos = beamOrigin.m_82549_(lookVec.m_82490_(beamInfo.endPos.m_82546_(beamInfo.startPos).m_82553_()));
        beamInfo.smoothedEndPos = BeamHandler.smoothPosition(beamInfo.smoothedEndPos, targetEndPos, smoothingFactor);
        beamInfo.lastStartPos = beamInfo.smoothedStartPos;
        beamInfo.lastEndPos = beamInfo.smoothedEndPos;
        beamInfo.updateFade(partialTicks);
        Vec3 currentStart = beamInfo.smoothedStartPos;
        ArrayList<Vec3> renderPoints = new ArrayList<Vec3>(beamInfo.glassPenetrationPoints);
        renderPoints.add(beamInfo.smoothedEndPos);
        for (Vec3 nextPoint : renderPoints) {
            BeamRenderer.renderBeam(poseStack, (MultiBufferSource)bufferSource, partialTicks, currentStart, nextPoint, currentStart, nextPoint, interpolatedColor, beamInfo.fadeProgress);
            currentStart = nextPoint;
        }
        beamPlayer.f_36100_ = originalBob;
        beamPlayer.f_36099_ = originalOBob;
        beamPlayer.f_19787_ = originalWalkDist;
        beamPlayer.f_19867_ = originalWalkDistO;
    }

    private static Vec3 calculateBeamOrigin(Player player, Gun modifiedGun, float partialTicks) {
        boolean isThirdPerson;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = isThirdPerson = mc.f_91066_.m_92176_().ordinal() > 0;
        if (!isThirdPerson) {
            return BeamHandler.calculateFirstPersonBeamOrigin(player, modifiedGun, partialTicks);
        }
        return BeamHandler.calculateThirdPersonBeamOrigin(player, modifiedGun, partialTicks);
    }

    private static Vec3 calculateFirstPersonBeamOrigin(Player player, Gun modifiedGun, float partialTicks) {
        Vec3 basePos = BeamHandler.calculateBasePosition(player, partialTicks);
        Vec3 lookVec = Vec3.m_82498_((float)Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()), (float)Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()));
        Vec3 upVec = Vec3.m_82498_((float)(Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) - 90.0f), (float)Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()));
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_();
        float aimProgress = AimingHandler.get().getAimProgress(player, partialTicks);
        double[] offsets = BeamHandler.calculateBeamOffsets(modifiedGun, aimProgress);
        return basePos.m_82549_(rightVec.m_82490_(offsets[0])).m_82549_(upVec.m_82490_(offsets[1])).m_82549_(lookVec.m_82490_(offsets[2]));
    }

    private static Vec3 calculateThirdPersonBeamOrigin(Player player, Gun modifiedGun, float partialTicks) {
        Vec3 basePos = new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + (double)player.m_20192_() - 0.2, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
        Vec3 lookVec = Vec3.m_82498_((float)Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()), (float)Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()));
        Vec3 upVec = Vec3.m_82498_((float)(Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) - 90.0f), (float)Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()));
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_();
        float aimProgress = AimingHandler.get().getAimProgress(player, partialTicks);
        BeamHandler.calculateBeamOffsets(modifiedGun, aimProgress);
        return basePos.m_82549_(rightVec.m_82490_(0.1)).m_82549_(upVec.m_82490_(-0.1)).m_82549_(lookVec.m_82490_(2.15));
    }

    private static Vec3 calculateBasePosition(Player player, float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + (double)player.m_20192_();
        double z = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_());
        return new Vec3(x, y, z);
    }

    private static double[] calculateBeamOffsets(Gun modifiedGun, float aimProgress) {
        double forwardOffset;
        double verticalOffset;
        double horizontalOffset;
        Gun.Display.BeamOrigin beamOriginConfig = modifiedGun.getDisplay().getBeamOrigin();
        if (beamOriginConfig != null) {
            horizontalOffset = Mth.m_14139_((double)aimProgress, (double)beamOriginConfig.getHorizontalOffset(), (double)beamOriginConfig.getAimHorizontalOffset());
            verticalOffset = beamOriginConfig.getVerticalOffset();
            forwardOffset = beamOriginConfig.getForwardOffset();
        } else {
            horizontalOffset = Mth.m_14139_((double)aimProgress, (double)0.1, (double)0.0);
            verticalOffset = -0.1;
            forwardOffset = 0.3;
        }
        return new double[]{horizontalOffset, verticalOffset, forwardOffset};
    }

    private static Vec3 smoothPosition(Vec3 previous, Vec3 current, float smoothingFactor) {
        if (previous == null) {
            return current;
        }
        return new Vec3(Mth.m_14139_((double)smoothingFactor, (double)previous.f_82479_, (double)current.f_82479_), Mth.m_14139_((double)smoothingFactor, (double)previous.f_82480_, (double)current.f_82480_), Mth.m_14139_((double)smoothingFactor, (double)previous.f_82481_, (double)current.f_82481_));
    }

    private static float[] interpolateColors(float[] colorA, float[] colorB, float progress) {
        float r = Mth.m_14179_((float)progress, (float)colorA[0], (float)colorB[0]);
        float g = Mth.m_14179_((float)progress, (float)colorA[1], (float)colorB[1]);
        float b = Mth.m_14179_((float)progress, (float)colorA[2], (float)colorB[2]);
        float a = Mth.m_14179_((float)progress, (float)colorA[3], (float)colorB[3]);
        return new float[]{r, g, b, a};
    }

    private static float[] parseBeamColor(String beamColorHex) {
        if (beamColorHex == null || beamColorHex.isEmpty()) {
            return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        try {
            float b;
            float g;
            float r;
            float a;
            if (beamColorHex.startsWith("#")) {
                beamColorHex = beamColorHex.substring(1);
            }
            long colorLong = Long.parseLong(beamColorHex, 16);
            if (beamColorHex.length() == 8) {
                a = (float)(colorLong >> 24 & 0xFFL) / 255.0f;
                r = (float)(colorLong >> 16 & 0xFFL) / 255.0f;
                g = (float)(colorLong >> 8 & 0xFFL) / 255.0f;
                b = (float)(colorLong & 0xFFL) / 255.0f;
            } else {
                a = 1.0f;
                r = (float)(colorLong >> 16 & 0xFFL) / 255.0f;
                g = (float)(colorLong >> 8 & 0xFFL) / 255.0f;
                b = (float)(colorLong & 0xFFL) / 255.0f;
            }
            return new float[]{r, g, b, a};
        }
        catch (NumberFormatException e) {
            return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
    }

    public static void spawnBeamImpactParticles(ClientLevel world, Vec3 hitPosition, Player player) {
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            float[] interpolatedColor = BeamHandler.getBeamColorForWeapon(heldItem, modifiedGun);
            for (int i = 0; i < 10; ++i) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * 0.2;
                double offsetY = (world.f_46441_.m_188500_() - 0.5) * 0.2;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 0.2;
                world.m_6493_((ParticleOptions)ModParticleTypes.BLOOD.get(), false, hitPosition.f_82479_ + offsetX, hitPosition.f_82480_ + offsetY, hitPosition.f_82481_ + offsetZ, (double)interpolatedColor[0], (double)interpolatedColor[1], (double)interpolatedColor[2]);
            }
        }
    }

    public static class BeamInfo {
        public Vec3 startPos;
        public Vec3 endPos;
        public Vec3 lastStartPos;
        public Vec3 lastEndPos;
        public Vec3 smoothedStartPos;
        public Vec3 smoothedEndPos;
        public float lastYaw;
        public float lastPitch;
        public Vec3 lastPlayerPos;
        public long startTime;
        public long lastDamageTime;
        public long lastUpdateTime;
        public int ticksActive;
        public boolean isBeamActive;
        public long expiryTime;
        public boolean isBeamFireMode;
        public float fadeProgress = 0.0f;
        private static final float FADE_SPEED = 2.0f;
        public List<Vec3> glassPenetrationPoints;

        public BeamInfo(Vec3 startPos, Vec3 endPos, long startTime, boolean isBeamFireMode) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.lastStartPos = startPos;
            this.lastEndPos = endPos;
            this.smoothedStartPos = startPos;
            this.smoothedEndPos = endPos;
            this.lastYaw = 0.0f;
            this.lastPitch = 0.0f;
            this.lastPlayerPos = new Vec3(0.0, 0.0, 0.0);
            this.startTime = startTime;
            this.lastDamageTime = startTime;
            this.lastUpdateTime = startTime;
            this.ticksActive = 0;
            this.expiryTime = 0L;
            this.isBeamFireMode = isBeamFireMode;
            this.glassPenetrationPoints = new ArrayList<Vec3>();
        }

        public void updatePositions(Vec3 newStartPos, Vec3 newEndPos) {
            this.lastStartPos = this.startPos;
            this.lastEndPos = this.endPos;
            this.startPos = newStartPos;
            this.endPos = newEndPos;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public void updateFade(float partialTicks) {
            if (!this.isBeamActive && this.fadeProgress < 1.0f) {
                this.fadeProgress = Math.min(1.0f, this.fadeProgress + 2.0f * partialTicks);
            } else if (this.isBeamActive) {
                this.fadeProgress = 0.0f;
            }
        }
    }
}

