/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.crosshair;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import top.ribs.scguns.client.handler.CrosshairHandler;
import top.ribs.scguns.client.handler.HUDRenderHandler;
import top.ribs.scguns.client.render.crosshair.Crosshair;

public class SpecialHitMarker
extends Crosshair {
    private static final ResourceLocation NORMAL_HITMARKER = new ResourceLocation("scguns", "textures/crosshair/special_hit_marker.png");
    private static final ResourceLocation ALT_HITMARKER = new ResourceLocation("scguns", "textures/crosshair/special_hit_marker2.png");

    public SpecialHitMarker() {
        super(new ResourceLocation("scguns", "special_hit_marker"));
    }

    @Override
    public void render(Minecraft mc, PoseStack stack, int windowWidth, int windowHeight, float partialTicks) {
        stack.m_85836_();
        float alpha = 1.0f;
        float size = 9.0f;
        float hitMarkerProgress = HUDRenderHandler.getHitMarkerProgress(partialTicks);
        boolean crit = HUDRenderHandler.getHitMarkerCrit();
        float scale = 1.5f + hitMarkerProgress * 1.0f;
        stack.m_85837_((double)Math.round((float)windowWidth / 2.0f) - 0.5, (double)Math.round((float)windowHeight / 2.0f) - 0.5, 0.0);
        stack.m_85841_(scale, scale, scale);
        stack.m_252880_(-size / 2.0f, -size / 2.0f, 0.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)(!crit ? 1.0f : 0.25f), (float)(!crit ? 1.0f : 0.25f), (float)(1.0f - hitMarkerProgress * 0.3f));
        boolean useAltHitMarker = CrosshairHandler.get().getCurrentCrosshair().getLocation().equals((Object)new ResourceLocation("scguns", "hit_marker"));
        ResourceLocation texture = useAltHitMarker ? ALT_HITMARKER : NORMAL_HITMARKER;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.enableBlend();
        Matrix4f matrix = stack.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, size, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size, size, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, size, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        stack.m_85849_();
    }
}

