/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitEffectsHandler;
import top.ribs.scguns.common.exosuit.ExoSuitNightVisionHandler;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageSyncExoSuitUpgrades;
import top.ribs.scguns.network.message.S2CMessageSyncUpgradeRegistry;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitEventHandler {
    private static int tickCounter = 0;
    private static final int UPDATE_FREQUENCY = 20;
    private static int syncCounter = 0;
    private static final int SYNC_INTERVAL = 200;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            if (++tickCounter >= 20) {
                tickCounter = 0;
                ExoSuitEventHandler.updatePlayerExoSuitEffects(event.player);
            }
            if (++syncCounter >= 200) {
                syncCounter = 0;
                Player player = event.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ExoSuitEventHandler.periodicExoSuitSync(serverPlayer);
                }
            }
        }
    }

    private static void periodicExoSuitSync(ServerPlayer player) {
        List nearbyPlayers = player.m_284548_().m_45976_(ServerPlayer.class, player.m_20191_().m_82400_(128.0));
        if (nearbyPlayers.size() <= 1) {
            return;
        }
        for (ItemStack armorStack : player.m_6168_()) {
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem)) continue;
            ExoSuitItem exosuit = (ExoSuitItem)item;
            EquipmentSlot slot = ExoSuitEventHandler.getSlotForArmorType(exosuit);
            CompoundTag upgradeData = ExoSuitData.getUpgradeData(armorStack);
            for (ServerPlayer nearbyPlayer : nearbyPlayers) {
                if (nearbyPlayer == player) continue;
                PacketHandler.getPlayChannel().sendToPlayer(() -> nearbyPlayer, (IMessage)new S2CMessageSyncExoSuitUpgrades(player.m_20148_(), slot, upgradeData));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ExoSuitEventHandler.updatePlayerExoSuitEffects(event.getEntity());
            Map<ResourceLocation, CompoundTag> upgradeData = ExoSuitUpgradeManager.serializeUpgrades();
            PacketHandler.getPlayChannel().sendToPlayer(() -> serverPlayer, (IMessage)new S2CMessageSyncUpgradeRegistry(upgradeData));
            ExoSuitEventHandler.syncAllExoSuitPiecesToPlayer(serverPlayer);
        }
    }

    private static void syncAllExoSuitPiecesToPlayer(ServerPlayer joiningPlayer) {
        List nearbyPlayers = joiningPlayer.m_284548_().m_45976_(ServerPlayer.class, joiningPlayer.m_20191_().m_82400_(128.0));
        for (ServerPlayer nearbyPlayer : nearbyPlayers) {
            for (ItemStack armorStack : nearbyPlayer.m_6168_()) {
                if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
                EquipmentSlot slot = ExoSuitEventHandler.getSlotForArmorType((ExoSuitItem)armorStack.m_41720_());
                CompoundTag upgradeData = ExoSuitData.getUpgradeData(armorStack);
                PacketHandler.getPlayChannel().sendToPlayer(() -> joiningPlayer, (IMessage)new S2CMessageSyncExoSuitUpgrades(nearbyPlayer.m_20148_(), slot, upgradeData));
            }
        }
    }

    private static EquipmentSlot getSlotForArmorType(ExoSuitItem exosuit) {
        return switch (exosuit.m_266204_()) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> EquipmentSlot.HEAD;
            case ArmorItem.Type.CHESTPLATE -> EquipmentSlot.CHEST;
            case ArmorItem.Type.LEGGINGS -> EquipmentSlot.LEGS;
            case ArmorItem.Type.BOOTS -> EquipmentSlot.FEET;
        };
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (ExoSuitEventHandler.hasAnyExoSuitPiece(event.getEntity())) {
            ExoSuitEffectsHandler.removeExoSuitEffects(event.getEntity());
            ExoSuitNightVisionHandler.onPlayerLogout(event.getEntity());
        }
        ExoSuitPowerManager.cleanupPlayerData(event.getEntity().m_20148_());
        ExoSuitEffectsHandler.cleanupPlayerData(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack from = event.getFrom();
        ItemStack to = event.getTo();
        boolean wasExoSuit = from.m_41720_() instanceof ExoSuitItem;
        boolean isExoSuit = to.m_41720_() instanceof ExoSuitItem;
        if (wasExoSuit || isExoSuit) {
            List nearbyPlayers = player.m_284548_().m_45976_(ServerPlayer.class, player.m_20191_().m_82400_(128.0));
            CompoundTag upgradeData = isExoSuit ? ExoSuitData.getUpgradeData(to) : new CompoundTag();
            for (ServerPlayer nearbyPlayer : nearbyPlayers) {
                PacketHandler.getPlayChannel().sendToPlayer(() -> nearbyPlayer, (IMessage)new S2CMessageSyncExoSuitUpgrades(player.m_20148_(), event.getSlot(), upgradeData));
            }
            ExoSuitEventHandler.updatePlayerExoSuitEffects((Player)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            Objects.requireNonNull(event.getEntity().m_9236_().m_7654_()).execute(() -> ExoSuitEventHandler.updatePlayerExoSuitEffects(event.getEntity()));
        }
    }

    private static void updatePlayerExoSuitEffects(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        boolean hasExoSuit = ExoSuitEventHandler.hasAnyExoSuitPiece(player);
        if (hasExoSuit) {
            ExoSuitEffectsHandler.applyExoSuitEffects(player);
            ExoSuitEventHandler.initializePowerStatesIfNeeded(player);
        } else {
            ExoSuitEffectsHandler.removeExoSuitEffects(player);
            ExoSuitNightVisionHandler.onPlayerLogout(player);
        }
    }

    private static boolean hasAnyExoSuitPiece(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            return true;
        }
        return false;
    }

    private static void initializePowerStatesIfNeeded(Player player) {
        if (ExoSuitEventHandler.hasUpgradeType(player, "hud") && !ExoSuitEventHandler.hasPowerState(player, "hud")) {
            ExoSuitPowerManager.setPowerEnabled(player, "hud", false);
        }
        if (ExoSuitEventHandler.hasUpgradeType(player, "mobility") && !ExoSuitEventHandler.hasPowerState(player, "mobility")) {
            ExoSuitPowerManager.setPowerEnabled(player, "mobility", false);
        }
    }

    private static boolean hasUpgradeType(Player player, String upgradeType) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals(upgradeType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasPowerState(Player player, String upgradeType) {
        return ExoSuitPowerManager.isPowerEnabled(player, upgradeType);
    }
}

