/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.NightVisionModuleItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitNightVisionHandler {
    private static final int REFRESH_INTERVAL = 150;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 10 != 0) {
            return;
        }
        ExoSuitNightVisionHandler.handleNightVisionEnergy(player);
    }

    private static void handleNightVisionEnergy(Player player) {
        NightVisionModuleItem nightVisionModule;
        Item item;
        if (!ExoSuitPowerManager.isPowerEnabled(player, "hud")) {
            return;
        }
        if (!ExoSuitNightVisionHandler.hasNightVisionModule(player)) {
            return;
        }
        if (!ExoSuitPowerManager.canConsumeEnergy(player, "hud", 150)) {
            return;
        }
        if (!ExoSuitPowerManager.canUpgradeFunction(player, "hud")) {
            return;
        }
        ItemStack helmetUpgrade = ExoSuitNightVisionHandler.findNightVisionModule(player);
        if (!helmetUpgrade.m_41619_() && (item = helmetUpgrade.m_41720_()) instanceof NightVisionModuleItem && !(nightVisionModule = (NightVisionModuleItem)item).canFunctionWithoutPower()) {
            ExoSuitPowerManager.consumeEnergyForUpgrade(player, "hud", helmetUpgrade);
        }
    }

    private static boolean hasNightVisionModule(Player player) {
        return !ExoSuitNightVisionHandler.findNightVisionModule(player).m_41619_();
    }

    private static ItemStack findNightVisionModule(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("hud") || !(upgradeItem.m_41720_() instanceof NightVisionModuleItem)) continue;
                return upgradeItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void onPlayerLogout(Player player) {
    }
}

