/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.enchantment;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModTags;

@Mod.EventBusSubscriber(modid="scguns")
public class CorrodedEnchantment
extends Enchantment {
    private static final Random RANDOM = new Random();

    public CorrodedEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 4;
    }

    public int m_6183_(int level) {
        return 5 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 20;
    }

    public void m_7677_(LivingEntity attacker, Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (CorrodedEnchantment.isBotEntity(livingTarget)) {
                this.spawnCorrodedParticles(livingTarget, level);
                return;
            }
            if (RANDOM.nextFloat() < 0.3f) {
                int poisonDuration = 60 + level * 20;
                livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonDuration, 0));
            }
        }
    }

    private void spawnCorrodedParticles(LivingEntity entity, int level) {
        Level level2 = entity.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            for (int i = 0; i < level * 5; ++i) {
                double offsetX = (RANDOM.nextDouble() - 0.5) * (double)entity.m_20205_();
                double offsetY = RANDOM.nextDouble() * (double)entity.m_20206_();
                double offsetZ = (RANDOM.nextDouble() - 0.5) * (double)entity.m_20205_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, entity.m_20185_() + offsetX, entity.m_20186_() + offsetY, entity.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public static boolean isBotEntity(LivingEntity entity) {
        return entity.m_6095_().m_204039_(ModTags.Entities.BOT);
    }

    public static float getBotDamageBonus(int level) {
        return (float)level * 2.0f;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target;
        int corrodedLevel;
        LivingEntity attacker;
        ItemStack weapon;
        if (event.getSource().m_7639_() instanceof LivingEntity && !(weapon = (attacker = (LivingEntity)event.getSource().m_7639_()).m_21205_()).m_41619_() && (corrodedLevel = weapon.getEnchantmentLevel((Enchantment)ModEnchantments.CORRODED.get())) > 0 && event.getEntity() instanceof LivingEntity && CorrodedEnchantment.isBotEntity(target = event.getEntity())) {
            float bonusDamage = CorrodedEnchantment.getBotDamageBonus(corrodedLevel);
            event.setAmount(event.getAmount() + bonusDamage);
        }
    }

    protected boolean m_5975_(Enchantment other) {
        return super.m_5975_(other) && !(other instanceof DamageEnchantment);
    }
}

