/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import top.ribs.scguns.entity.monster.HiveEntity;

public class HiveModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart Hive;
    private final ModelPart Torso;
    private final ModelPart Head;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;

    public HiveModel(ModelPart root) {
        this.Hive = root.m_171324_("Hive");
        this.Torso = this.Hive.m_171324_("Torso");
        this.Head = this.Torso.m_171324_("Head");
        this.LeftArm = this.Torso.m_171324_("LeftArm");
        this.RightArm = this.Torso.m_171324_("RightArm");
        this.LeftLeg = this.Hive.m_171324_("LeftLeg");
        this.RightLeg = this.Hive.m_171324_("RightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Hive = partdefinition.m_171599_("Hive", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Torso = Hive.m_171599_("Torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-25.0f, (float)4.0f));
        PartDefinition TorsoInt = Torso.m_171599_("TorsoInt", CubeListBuilder.m_171558_().m_171514_(27, 10).m_171488_(-3.0f, 4.5f, -3.5f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(27, 0).m_171488_(-2.0f, 2.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(15, 33).m_171488_(-2.0f, -2.5f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.5f, (float)-2.5f));
        PartDefinition cube_r1 = TorsoInt.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-2.0f, -2.5f, 0.0f, 4.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r2 = TorsoInt.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(25, 26).m_171488_(-4.0f, -0.1f, 0.0f, 8.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.5f, (float)-3.5f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = TorsoInt.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.5f, (float)-3.5f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition Head2 = Torso.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-4.0f, -4.0f, 8.0f, 8.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)4.0f));
        PartDefinition cube_r4 = Head2.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(20, 43).m_171488_(-7.0f, -5.0f, -4.0f, 8.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(36, 43).m_171488_(-7.0f, -5.0f, 4.0f, 8.0f, 18.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition LeftArm = Torso.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(52, 40).m_171488_(-3.0f, -2.0f, -2.0f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-1.0f, (float)2.0f));
        PartDefinition RightArm = Torso.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(52, 40).m_171480_().m_171488_(0.0f, -2.0f, -2.0f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-1.0f, (float)2.0f));
        PartDefinition LeftLeg = Hive.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(-1.0f, 11.0f, -2.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-2.0f, 0.0f, -3.0f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-16.0f, (float)0.0f));
        PartDefinition RightLeg = Hive.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171480_().m_171488_(-2.0f, 11.0f, -2.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 33).m_171480_().m_171488_(-2.0f, 0.0f, -3.0f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-16.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float spawnProgress;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        HiveEntity hiveEntity = entity instanceof HiveEntity ? (HiveEntity)((Object)entity) : null;
        boolean isSpawning = hiveEntity != null && hiveEntity.isSpawning();
        float f = spawnProgress = hiveEntity != null ? hiveEntity.getSpawnAnimationProgress(0.0f) : 0.0f;
        if (isSpawning) {
            float spawnCurve = Mth.m_14031_((float)(spawnProgress * (float)Math.PI));
            this.LeftArm.f_104203_ = -0.5f - spawnCurve * 1.2f;
            this.LeftArm.f_104205_ = -spawnCurve * 0.8f;
            this.RightArm.f_104203_ = -0.5f - spawnCurve * 1.2f;
            this.RightArm.f_104205_ = spawnCurve * 0.8f;
            this.Torso.f_104203_ = -spawnCurve * 0.3f;
            this.Head.f_104203_ = -spawnCurve * 0.4f;
            return;
        }
        if (limbSwingAmount > 0.01f) {
            float legSwing;
            this.LeftLeg.f_104203_ = legSwing = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightLeg.f_104203_ = -legSwing;
            float armSwing = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
            float twitchTime = ageInTicks * 0.3f;
            float twitch = Mth.m_14031_((float)twitchTime) * 0.05f;
            this.LeftArm.f_104203_ = -armSwing + twitch;
            this.RightArm.f_104203_ = armSwing - twitch;
            this.LeftArm.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount - 0.1f;
            this.RightArm.f_104205_ = -Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount + 0.1f;
            float lurch = Mth.m_14031_((float)(limbSwing * 0.6662f)) * 0.08f * limbSwingAmount;
            this.Torso.f_104203_ = lurch + 0.1f;
            this.Torso.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.3331f)) * 0.12f * limbSwingAmount;
        }
        float breatheTime = ageInTicks * 0.08f;
        float breathe = Mth.m_14031_((float)breatheTime) * 0.04f;
        float breathePulse = Mth.m_14031_((float)(breatheTime * 2.0f)) * 0.02f;
        this.Torso.f_104201_ += breathe + breathePulse;
        this.Torso.f_104203_ += breathePulse * 2.0f;
        float headSway = Mth.m_14031_((float)(ageInTicks * 0.05f)) * 0.04f;
        float headTwitch = Mth.m_14031_((float)(ageInTicks * 0.15f)) * 0.015f;
        this.Head.f_104204_ = headSway + headTwitch;
        this.Head.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.03f + headTwitch;
        if (ageInTicks % 180.0f < 2.0f) {
            this.Head.f_104204_ += 0.15f;
        }
        this.Head.f_104205_ = Mth.m_14031_((float)(ageInTicks * 0.4f)) * 0.02f;
        if (ageInTicks % 160.0f < 3.0f) {
            float jerkAmount = ageInTicks % 160.0f / 3.0f;
            this.LeftArm.f_104203_ += Mth.m_14031_((float)(jerkAmount * (float)Math.PI)) * 0.4f;
            this.RightArm.f_104203_ -= Mth.m_14031_((float)(jerkAmount * (float)Math.PI)) * 0.4f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Hive.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.Hive;
    }
}

