/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.item.GunItem;

public class FrogDartProjectileEntity
extends ProjectileEntity {
    private static final double UNDERWATER_SPEED_MULTIPLIER = 1.5;
    private static final double LAND_SPEED_MULTIPLIER = 0.6;
    private static final double UNDERWATER_GRAVITY_REDUCTION = 0.1;
    private static final double LAND_GRAVITY_MULTIPLIER = 3.0;
    private static final float LAND_DAMAGE_PENALTY = 0.65f;
    private boolean wasUnderwater = false;

    public FrogDartProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FrogDartProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20256_(motion.m_82490_(1.5));
            this.wasUnderwater = true;
        }
    }

    @Override
    public void m_8119_() {
        boolean currentlyUnderwater = this.m_20069_();
        if (currentlyUnderwater && !this.wasUnderwater) {
            Vec3 motion = this.m_20184_();
            this.m_20256_(motion.m_82490_(2.5));
        } else if (!currentlyUnderwater && this.wasUnderwater) {
            Vec3 motion = this.m_20184_();
            this.m_20256_(motion.m_82490_(0.39999999999999997));
        }
        this.wasUnderwater = currentlyUnderwater;
        super.m_8119_();
    }

    @Override
    protected void onProjectileTick() {
        Vec3 motion;
        if (this.m_20069_() && (motion = this.m_20184_()).m_82556_() > 0.001) {
            this.m_20256_(motion.m_82490_(1.02));
        }
    }

    @Override
    public double getModifiedGravity() {
        if (this.m_20069_()) {
            return super.getModifiedGravity() * 0.1;
        }
        return super.getModifiedGravity() * 3.0;
    }

    @Override
    public float getDamage() {
        float baseDamage = super.getDamage();
        if (!this.m_20069_()) {
            baseDamage *= 0.65f;
        }
        return baseDamage;
    }
}

