/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.config.RaidConfig;
import top.ribs.scguns.config.RaidFlareConfig;
import top.ribs.scguns.entity.raid.RaidManager;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageRaidFlareBurst;

public class RaidFlareEntity
extends ThrowableProjectile {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<String> RAID_ID = SynchedEntityData.m_135353_(RaidFlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private String raidId;
    private int ticksExisted = 0;
    private boolean hasBurst = false;

    public RaidFlareEntity(EntityType<? extends RaidFlareEntity> type, Level level) {
        super(type, level);
    }

    public RaidFlareEntity(Level level, LivingEntity shooter, String raidId) {
        super((EntityType)ModEntities.RAID_FLARE.get(), shooter, level);
        this.raidId = raidId;
        this.f_19804_.m_135381_(RAID_ID, (Object)raidId);
    }

    public String getRaidId() {
        if (this.raidId == null || this.raidId.isEmpty()) {
            this.raidId = (String)this.f_19804_.m_135370_(RAID_ID);
        }
        return this.raidId;
    }

    protected void m_6532_(HitResult result) {
        if (!this.m_9236_().f_46443_ && !this.hasBurst) {
            String currentRaidId = this.getRaidId();
            if (currentRaidId == null || currentRaidId.isEmpty()) {
                return;
            }
            RaidFlareConfig.FlareData flareData = RaidFlareConfig.getFlareData(currentRaidId);
            if (flareData == null) {
                return;
            }
            this.performBurst(flareData);
            this.hasBurst = true;
            this.m_20256_(Vec3.f_82478_);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_6532_((HitResult)result);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticksExisted;
        String currentRaidId = this.getRaidId();
        if (currentRaidId == null || currentRaidId.isEmpty()) {
            if (!this.m_9236_().f_46443_) {
                this.m_146870_();
            }
            return;
        }
        RaidFlareConfig.FlareData flareData = RaidFlareConfig.getFlareData(currentRaidId);
        if (flareData == null) {
            if (this.ticksExisted > 200 && !this.m_9236_().f_46443_) {
                this.m_146870_();
            }
            return;
        }
        if (this.m_9236_().f_46443_ && this.ticksExisted % 2 == 0) {
            this.spawnTrailParticles(flareData);
        }
        if (!this.m_9236_().f_46443_ && this.ticksExisted >= flareData.burstDelay() && !this.hasBurst) {
            this.performBurst(flareData);
            this.hasBurst = true;
        }
        if (this.hasBurst && this.ticksExisted >= flareData.burstDelay() + 40 && !this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        Vec3 motion = this.m_20184_();
        if (!this.m_20096_() && !this.hasBurst) {
            this.m_20334_(motion.f_82479_ * 0.99, motion.f_82480_ - 0.04, motion.f_82481_ * 0.99);
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
    }

    private void spawnTrailParticles(RaidFlareConfig.FlareData flareData) {
        for (RaidFlareConfig.ParticleEffect effect : flareData.trailParticles()) {
            ParticleOptions particle = this.getParticleType(effect.particleType());
            if (particle == null) continue;
            for (int i = 0; i < effect.count(); ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * effect.spread();
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * effect.spread();
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * effect.spread();
                this.m_9236_().m_7106_(particle, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, offsetX * effect.speed(), offsetY * effect.speed(), offsetZ * effect.speed());
            }
        }
    }

    private void performBurst(RaidFlareConfig.FlareData flareData) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(flareData.burstSound()));
        if (sound != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.AMBIENT, flareData.burstSoundVolume(), flareData.burstSoundPitch());
        }
        this.sendBurstParticlePacket(serverLevel, flareData);
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            RaidConfig.RaidData config = RaidConfig.getRaidByRaidId(flareData.raidId());
            if (config != null) {
                RaidManager manager = RaidManager.get(serverLevel);
                manager.startRaidFromPlayer(config, serverLevel, player);
            }
        }
    }

    private void sendBurstParticlePacket(ServerLevel level, RaidFlareConfig.FlareData flareData) {
        ArrayList<S2CMessageRaidFlareBurst.ParticleData> particles = new ArrayList<S2CMessageRaidFlareBurst.ParticleData>();
        for (RaidFlareConfig.ParticleEffect effect : flareData.burstParticles()) {
            particles.add(new S2CMessageRaidFlareBurst.ParticleData(effect.particleType(), effect.count(), effect.spread(), effect.speed(), effect.color()));
        }
        S2CMessageRaidFlareBurst message = this.createBurstMessage(flareData, particles);
        PacketHandler.getPlayChannel().sendToTrackingEntity(() -> this, (IMessage)message);
    }

    @NotNull
    private S2CMessageRaidFlareBurst createBurstMessage(RaidFlareConfig.FlareData flareData, List<S2CMessageRaidFlareBurst.ParticleData> particles) {
        String patternType = "default";
        double scale = 3.0;
        int repetitions = 1;
        if (flareData.pattern() != null) {
            patternType = flareData.pattern().patternType();
            scale = flareData.pattern().scale();
            repetitions = flareData.pattern().repetitions();
        }
        return new S2CMessageRaidFlareBurst(this.m_20185_(), this.m_20186_(), this.m_20189_(), patternType, scale, repetitions, particles);
    }

    @Nullable
    private ParticleOptions getParticleType(String particleId) {
        try {
            ResourceLocation location = new ResourceLocation(particleId);
            return (ParticleOptions)BuiltInRegistries.f_257034_.m_7745_(location);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("RaidId", this.getRaidId());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("RaidId")) {
            this.raidId = tag.m_128461_("RaidId");
            this.f_19804_.m_135381_(RAID_ID, (Object)this.raidId);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RAID_ID, (Object)"");
    }
}

