/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModTags;

@Mod.EventBusSubscriber(modid="scguns")
public class PiglinWeaponEventHandler {
    private static final String COOLDOWN_TAG = "PiglinWeaponCooldown";

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PiglinWeaponEventHandler.applyLavaResistance(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PiglinWeaponEventHandler.applyLavaResistance(player);
        }
    }

    private static void applyLavaResistance(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        boolean holdingSpecialItem = PiglinWeaponEventHandler.isPiglinWeapon(mainHandItem) || PiglinWeaponEventHandler.isPiglinWeapon(offHandItem);
        boolean isInLava = player.m_204029_(FluidTags.f_13132_);
        int cooldown = PiglinWeaponEventHandler.getCooldown(player);
        if (holdingSpecialItem && isInLava && cooldown <= 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400, 0, false, false, true));
            PiglinWeaponEventHandler.setCooldown(player, 600);
        } else if (cooldown > 0) {
            PiglinWeaponEventHandler.reduceCooldown(player);
        }
    }

    private static boolean isPiglinWeapon(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_204117_(ModTags.Items.PIGLIN_GUN);
    }

    private static int getCooldown(Player player) {
        CompoundTag tag = player.getPersistentData();
        return tag.m_128441_(COOLDOWN_TAG) ? tag.m_128451_(COOLDOWN_TAG) : 0;
    }

    private static void setCooldown(Player player, int cooldown) {
        player.getPersistentData().m_128405_(COOLDOWN_TAG, cooldown);
    }

    private static void reduceCooldown(Player player) {
        int cooldown = PiglinWeaponEventHandler.getCooldown(player);
        if (cooldown > 0) {
            PiglinWeaponEventHandler.setCooldown(player, cooldown - 1);
        }
    }
}

