/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import top.ribs.scguns.enchantment.EnchantmentTypes;
import top.ribs.scguns.interfaces.IGunModifier;
import top.ribs.scguns.item.UnderBarrelItem;
import top.ribs.scguns.item.attachment.impl.UnderBarrel;

public class BayonetItem
extends UnderBarrelItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final IGunModifier modifier;

    public BayonetItem(UnderBarrel underBarrel, Item.Properties properties, float attackDamage, float attackSpeed) {
        super(underBarrel, properties);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.modifier = underBarrel.getModifier();
    }

    public BayonetItem(UnderBarrel underBarrel, Item.Properties properties, boolean colored, float attackDamage, float attackSpeed) {
        super(underBarrel, properties, colored);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.modifier = underBarrel.getModifier();
    }

    public float getAdditionalDamage() {
        return this.modifier.additionalDamage();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentTypes.BAYONET || enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 10;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        }
        return super.m_7167_(equipmentSlot);
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_60713_(Blocks.f_50033_) ? 15.0f : 1.0f;
    }

    public boolean m_8096_(BlockState block) {
        return block.m_60713_(Blocks.f_50033_);
    }
}

