/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.item.TeamLogItem;

public class EnemyLogItem
extends TeamLogItem {
    public EnemyLogItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ListTag whitelistTag;
            int i;
            ListTag listTag;
            if (tag.m_128425_("Whitelist", 9) && !(listTag = tag.m_128437_("Whitelist", 10)).isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Whitelisted Entities:"));
                for (i = 0; i < listTag.size(); ++i) {
                    CompoundTag entityTag = listTag.m_128728_(i);
                    String entityName = entityTag.m_128461_("Name");
                    String entityType = entityTag.m_128461_("EntityType");
                    tooltip.add((Component)Component.m_237113_((String)("- " + entityName + " (" + entityType + ")")));
                }
            }
            if (tag.m_128425_("WhitelistEntityTypes", 9) && !(whitelistTag = tag.m_128437_("WhitelistEntityTypes", 8)).isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)"Whitelisted Entity Types:"));
                for (i = 0; i < whitelistTag.size(); ++i) {
                    String entityType = whitelistTag.m_128778_(i);
                    tooltip.add((Component)Component.m_237113_((String)("- " + entityType)));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No entities or types whitelisted"));
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        Entity entity;
        EntityHitResult hitResult;
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.m_5776_() && (hitResult = this.rayTraceEntities(level, player)) != null && (entity = hitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)entity;
            if (player.m_6144_()) {
                boolean added = this.addEntityTypeToWhitelist(itemStack, targetEntity);
                if (added) {
                    player.m_5661_((Component)Component.m_237113_((String)("Added all " + targetEntity.m_6095_().m_20676_().getString() + " to whitelist")), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)(targetEntity.m_6095_().m_20676_().getString() + " is already whitelisted")), true);
                }
            } else {
                boolean added = this.addEntityToWhitelist(itemStack, targetEntity);
                if (added) {
                    player.m_5661_((Component)Component.m_237113_((String)("Added " + targetEntity.m_7755_().getString() + " to Whitelist")), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)(targetEntity.m_7755_().getString() + " is already in Whitelist")), true);
                }
            }
            this.logCurrentWhitelist(itemStack, player);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    boolean addEntityToWhitelist(ItemStack stack, LivingEntity targetEntity) {
        CompoundTag tag = stack.m_41784_();
        ListTag listTag = tag.m_128437_("Whitelist", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag existingTag = listTag.m_128728_(i);
            if (!existingTag.m_128342_("UUID").equals(targetEntity.m_20148_())) continue;
            return false;
        }
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128362_("UUID", targetEntity.m_20148_());
        entityTag.m_128359_("Name", targetEntity.m_7755_().getString());
        entityTag.m_128359_("EntityType", EntityType.m_20613_((EntityType)targetEntity.m_6095_()).toString());
        listTag.add((Object)entityTag);
        tag.m_128365_("Whitelist", (Tag)listTag);
        stack.m_41751_(tag);
        return true;
    }

    boolean addEntityTypeToWhitelist(ItemStack stack, LivingEntity targetEntity) {
        CompoundTag tag = stack.m_41784_();
        ListTag whitelistTag = tag.m_128437_("WhitelistEntityTypes", 8);
        String entityTypeKey = EntityType.m_20613_((EntityType)targetEntity.m_6095_()).toString();
        for (int i = 0; i < whitelistTag.size(); ++i) {
            if (!whitelistTag.m_128778_(i).equals(entityTypeKey)) continue;
            return false;
        }
        whitelistTag.add((Object)StringTag.m_129297_((String)entityTypeKey));
        tag.m_128365_("WhitelistEntityTypes", (Tag)whitelistTag);
        stack.m_41751_(tag);
        return true;
    }

    void logCurrentWhitelist(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            int i;
            if (tag.m_128425_("Whitelist", 9)) {
                ListTag listTag = tag.m_128437_("Whitelist", 10);
                if (!listTag.isEmpty()) {
                    player.m_5661_((Component)Component.m_237113_((String)"Entities in Whitelist:"), true);
                    for (i = 0; i < listTag.size(); ++i) {
                        CompoundTag entityTag = listTag.m_128728_(i);
                        String entityName = entityTag.m_128461_("Name");
                        String entityType = entityTag.m_128461_("EntityType");
                        player.m_5661_((Component)Component.m_237113_((String)("- " + entityName + " (" + entityType + ")")), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"No specific entities whitelisted."), true);
                }
            }
            if (tag.m_128425_("WhitelistEntityTypes", 9)) {
                ListTag whitelistTag = tag.m_128437_("WhitelistEntityTypes", 8);
                if (!whitelistTag.isEmpty()) {
                    player.m_5661_((Component)Component.m_237113_((String)"Whitelisted Entity Types:"), true);
                    for (i = 0; i < whitelistTag.size(); ++i) {
                        String entityType = whitelistTag.m_128778_(i);
                        player.m_5661_((Component)Component.m_237113_((String)("- " + entityType)), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"No entity types whitelisted."), true);
                }
            }
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"No entities or types logged in the item."), true);
        }
    }
}

