/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.ribs.scguns.init.ModEffects;

public class WeirdFleshItem
extends Item {
    private static final Map<MobEffect, EffectData> WEIRD_FLESH_EFFECTS = new HashMap<MobEffect, EffectData>();

    public WeirdFleshItem() {
        super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38757_().m_38765_().m_38767_()));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.m_5922_(stack, level, entity);
        if (!level.m_5776_()) {
            this.applyRandomEffect(entity);
        }
        return result;
    }

    private void applyRandomEffect(LivingEntity entity) {
        Random random = new Random();
        int totalWeight = 0;
        for (EffectData data : WEIRD_FLESH_EFFECTS.values()) {
            totalWeight += data.weight;
        }
        int roll = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (Map.Entry<MobEffect, EffectData> entry : WEIRD_FLESH_EFFECTS.entrySet()) {
            if (roll >= (currentWeight += entry.getValue().weight)) continue;
            MobEffect effect = entry.getKey();
            EffectData data = entry.getValue();
            int duration = data.getDuration(random);
            int amplifier = data.getAmplifier(random);
            entity.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            break;
        }
    }

    static {
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19614_, new EffectData(20, 100, 200, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19604_, new EffectData(18, 100, 180, 0, 0));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19613_, new EffectData(15, 80, 160, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19597_, new EffectData(15, 60, 140, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19612_, new EffectData(25, 100, 300, 0, 2));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19610_, new EffectData(12, 60, 120, 0, 0));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19615_, new EffectData(10, 40, 100, 0, 1));
        WEIRD_FLESH_EFFECTS.put((MobEffect)ModEffects.SULFUR_POISONING.get(), new EffectData(12, 60, 140, 0, 1));
        WEIRD_FLESH_EFFECTS.put((MobEffect)ModEffects.BLINDED.get(), new EffectData(10, 40, 100, 0, 0));
        WEIRD_FLESH_EFFECTS.put((MobEffect)ModEffects.DEAFENED.get(), new EffectData(10, 40, 100, 0, 0));
        WEIRD_FLESH_EFFECTS.put((MobEffect)ModEffects.LACERATED.get(), new EffectData(8, 80, 160, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19620_, new EffectData(8, 40, 80, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19599_, new EffectData(10, 60, 120, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19605_, new EffectData(5, 60, 120, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19606_, new EffectData(4, 60, 140, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19596_, new EffectData(6, 100, 200, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19617_, new EffectData(3, 80, 160, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19607_, new EffectData(4, 100, 200, 0, 0));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19608_, new EffectData(4, 100, 200, 0, 0));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19611_, new EffectData(5, 100, 300, 0, 0));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19601_, new EffectData(2, 1, 1, 0, 1));
        WEIRD_FLESH_EFFECTS.put(MobEffects.f_19602_, new EffectData(3, 1, 1, 0, 1));
    }

    private record EffectData(int weight, int minDuration, int maxDuration, int minAmplifier, int maxAmplifier) {
        int getDuration(Random random) {
            if (this.minDuration == this.maxDuration) {
                return this.minDuration;
            }
            return this.minDuration + random.nextInt(this.maxDuration - this.minDuration + 1);
        }

        int getAmplifier(Random random) {
            if (this.minAmplifier == this.maxAmplifier) {
                return this.minAmplifier;
            }
            return this.minAmplifier + random.nextInt(this.maxAmplifier - this.minAmplifier + 1);
        }
    }
}

