/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class PlayerScampManager {
    private static final Map<UUID, PlayerScampData> PLAYER_DATA = new HashMap<UUID, PlayerScampData>();

    public static PlayerScampData getOrCreatePlayerData(Player player) {
        return PLAYER_DATA.computeIfAbsent(player.m_20148_(), k -> new PlayerScampData());
    }

    public static void init() {
        PLAYER_DATA.clear();
    }

    public static void savePlayerData(Player player) {
        PlayerScampData data = PLAYER_DATA.get(player.m_20148_());
        if (data != null && data.isDirty) {
            CompoundTag persistentData = player.getPersistentData();
            CompoundTag scampData = new CompoundTag();
            data.saveToNBT(scampData);
            persistentData.m_128365_("ScampManagerData", (Tag)scampData);
            data.isDirty = false;
        }
    }

    public static void loadPlayerData(Player player) {
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_("ScampManagerData")) {
            PlayerScampData data = new PlayerScampData();
            data.loadFromNBT(persistentData.m_128469_("ScampManagerData"));
            PLAYER_DATA.put(player.m_20148_(), data);
        }
    }

    public static class PlayerScampData {
        private UUID linkedScampId;
        private BlockPos containerPos;
        private boolean isDirty = false;

        public UUID getLinkedScampId() {
            return this.linkedScampId;
        }

        public void setLinkedScampId(UUID scampId) {
            this.linkedScampId = scampId;
            this.isDirty = true;
        }

        public BlockPos getContainerPos() {
            return this.containerPos;
        }

        public void setContainerPos(BlockPos pos) {
            this.containerPos = pos;
            this.isDirty = true;
        }

        public void saveToNBT(CompoundTag tag) {
            if (this.linkedScampId != null) {
                tag.m_128362_("LinkedScampId", this.linkedScampId);
            }
            if (this.containerPos != null) {
                tag.m_128405_("ContainerX", this.containerPos.m_123341_());
                tag.m_128405_("ContainerY", this.containerPos.m_123342_());
                tag.m_128405_("ContainerZ", this.containerPos.m_123343_());
            }
        }

        public void loadFromNBT(CompoundTag tag) {
            if (tag.m_128403_("LinkedScampId")) {
                this.linkedScampId = tag.m_128342_("LinkedScampId");
            }
            if (tag.m_128441_("ContainerX")) {
                this.containerPos = new BlockPos(tag.m_128451_("ContainerX"), tag.m_128451_("ContainerY"), tag.m_128451_("ContainerZ"));
            }
        }
    }
}

