/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.client.model;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.client.model.AirDuctBakedModel;

public class AirDuctModel
implements UnbakedModel {
    private final ResourceLocation straight;
    private final ResourceLocation corner;
    private final ResourceLocation cover;
    private final ResourceLocation frame;

    public AirDuctModel(ResourceLocation straight, ResourceLocation corner, ResourceLocation cover, ResourceLocation frame) {
        this.straight = straight;
        this.corner = corner;
        this.cover = cover;
        this.frame = frame;
    }

    public Collection<ResourceLocation> m_7970_() {
        return List.of(this.straight, this.corner, this.cover, this.frame);
    }

    public void m_5500_(Function<ResourceLocation, UnbakedModel> pResolver) {
        this.m_7970_().stream().map(pResolver).forEach($ -> $.m_5500_(pResolver));
    }

    @Nullable
    public BakedModel m_7611_(ModelBaker pBaker, Function<Material, TextureAtlasSprite> pSpriteGetter, ModelState pState, ResourceLocation pLocation) {
        BlockModelRotation rotation2;
        ImmutableList.Builder straightModels = ImmutableList.builder();
        for (BlockModelRotation rotation2 : List.of(BlockModelRotation.X90_Y90, BlockModelRotation.X0_Y0, BlockModelRotation.X90_Y0)) {
            BakedModel baked = pBaker.m_245240_(this.straight, (ModelState)rotation2);
            if (baked == null) {
                XKDeco.LOGGER.warn("Failed to bake air duct model: {}", (Object)this.straight);
                return null;
            }
            straightModels.add((Object)baked);
        }
        ImmutableList.Builder cornerModels = ImmutableList.builder();
        rotation2 = IntList.of((int)0, (int)90, (int)270).iterator();
        while (rotation2.hasNext()) {
            int x = (Integer)rotation2.next();
            IntListIterator intListIterator = IntList.of((int[])new int[]{0, 90, 180, 270}).iterator();
            while (intListIterator.hasNext()) {
                int y = (Integer)intListIterator.next();
                BakedModel baked = pBaker.m_245240_(this.corner, (ModelState)BlockModelRotation.m_119153_((int)x, (int)y));
                if (baked == null) {
                    XKDeco.LOGGER.warn("Failed to bake air duct model: {}", (Object)this.corner);
                    return null;
                }
                cornerModels.add((Object)baked);
            }
        }
        ImmutableList.Builder coverModels = ImmutableList.builder();
        IntListIterator x = IntList.of((int)270, (int)90).iterator();
        while (x.hasNext()) {
            int x2 = (Integer)x.next();
            BakedModel baked = pBaker.m_245240_(this.cover, (ModelState)BlockModelRotation.m_119153_((int)x2, (int)0));
            if (baked == null) {
                XKDeco.LOGGER.warn("Failed to bake air duct model: {}", (Object)this.cover);
                return null;
            }
            coverModels.add((Object)baked);
        }
        x = IntList.of((int[])new int[]{180, 0, 90, 270}).iterator();
        while (x.hasNext()) {
            int y = (Integer)x.next();
            BakedModel baked = pBaker.m_245240_(this.cover, (ModelState)BlockModelRotation.m_119153_((int)0, (int)y));
            if (baked == null) {
                XKDeco.LOGGER.warn("Failed to bake air duct model: {}", (Object)this.cover);
                return null;
            }
            coverModels.add((Object)baked);
        }
        BakedModel frameModel = pBaker.m_245240_(this.frame, (ModelState)BlockModelRotation.X0_Y0);
        if (frameModel == null) {
            XKDeco.LOGGER.warn("Failed to bake air duct model: {}", (Object)this.frame);
            return null;
        }
        return new AirDuctBakedModel((List<BakedModel>)straightModels.build(), (List<BakedModel>)cornerModels.build(), (List<BakedModel>)coverModels.build(), frameModel);
    }
}

