/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBlock;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.block.MimicWallBlock;
import org.teacon.xkdeco.block.XKDBlock;
import org.teacon.xkdeco.util.CommonProxy;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class MimicWallsLoader {
    private static ImmutableList<MimicWallBlock> MIMIC_WALLS = ImmutableList.of();
    private static final List<MimicWallBlock> PENDING_MIMIC_WALLS = Lists.newArrayList();
    public static final ResourceKey<CreativeModeTab> STRUCTURE_TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)XKDeco.id("structure"));

    public static ImmutableList<MimicWallBlock> mimicWalls() {
        if (!PENDING_MIMIC_WALLS.isEmpty()) {
            MIMIC_WALLS = ImmutableList.builder().addAll(MIMIC_WALLS).addAll(PENDING_MIMIC_WALLS).build();
            PENDING_MIMIC_WALLS.clear();
        }
        return MIMIC_WALLS;
    }

    public static void addMimicWalls() {
        for (Holder holder : BuiltInRegistries.f_256975_.m_206115_()) {
            MimicWallsLoader.newBlockAdded(((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_(), (Block)holder.m_203334_());
        }
    }

    public static void newBlockAdded(ResourceLocation id, Block block) {
        if (block instanceof WallBlock) {
            WallBlock wall = (WallBlock)block;
            if (!(block instanceof MimicWallBlock) && !block.m_49966_().m_155947_() && id.m_135815_().endsWith("_wall") && block.m_49965_().m_61092_().size() == Blocks.f_50274_.m_49965_().m_61092_().size()) {
                MimicWallBlock mimicWall = new MimicWallBlock(wall);
                String name = MimicWallBlock.toMimicId(id);
                id = XKDeco.id(name);
                CommonProxy.registerBlock(id, (Block)mimicWall);
                CommonProxy.registerItem(id, (Item)new ModBlockItem((Block)mimicWall, new Item.Properties()));
                PENDING_MIMIC_WALLS.add(mimicWall);
            }
        }
    }

    public static void addMimicWallBlockTags(Map<ResourceLocation, Collection<Holder<Block>>> tags) {
        List walls = MimicWallsLoader.mimicWalls().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_263177_(arg_0)).toList();
        MimicWallsLoader.appendTagValues(tags, BlockTags.f_13032_, walls);
        MimicWallsLoader.appendTagValues(tags, BlockTags.f_144282_, walls);
        MimicWallsLoader.appendTagValues(tags, XKDBlock.NON_DIAGONAL_WALLS, walls);
    }

    public static void addMimicWallItemTags(Map<ResourceLocation, Collection<Holder<Item>>> tags) {
        List walls = MimicWallsLoader.mimicWalls().stream().map(Block::m_5456_).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_263177_(arg_0)).toList();
        MimicWallsLoader.appendTagValues(tags, ItemTags.f_13140_, walls);
    }

    private static <T> void appendTagValues(Map<ResourceLocation, Collection<Holder<T>>> tags, TagKey<T> key, List<Holder<T>> holders) {
        ArrayList list = Lists.newArrayList((Iterable)tags.getOrDefault(key.f_203868_(), List.of()));
        list.addAll(holders);
        tags.put(key.f_203868_(), list);
    }
}

