/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.teacon.xkdeco.block.RoofRidgeBlock;
import snownee.kiwi.customization.placement.PlaceSlot;

@Mixin(value={WallBlock.class})
public abstract class WallBlockMixin {
    @Unique
    private boolean xkdeco$isRoofRidge() {
        return this.getClass() == RoofRidgeBlock.class;
    }

    @Inject(method={"updateSides"}, at={@At(value="HEAD")}, cancellable=true)
    private void xkdeco$updateSides(BlockState blockState, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape, CallbackInfoReturnable<BlockState> cir) {
        if (this.xkdeco$isRoofRidge()) {
            cir.setReturnValue((Object)blockState);
        }
    }

    @Inject(method={"connectsTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void xkdeco$connectsTo(BlockState blockState, boolean sideSolid, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        if (this.xkdeco$isRoofRidge()) {
            cir.setReturnValue((Object)(blockState.m_60734_().getClass() == RoofRidgeBlock.class || !Block.m_152463_((BlockState)blockState) && sideSolid || PlaceSlot.find((BlockState)blockState, (Direction)direction, (String)"*roof_ridge_end").isPresent() ? 1 : 0));
        }
    }

    @Inject(method={"sideUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void xkdeco$sideUpdate(LevelReader level, BlockPos firstPos, BlockState firstState, BlockPos secondPos, BlockState secondState, Direction direction, CallbackInfoReturnable<BlockState> cir) {
        if (this.xkdeco$isRoofRidge()) {
            WallSide wallSide = RoofRidgeBlock.makeSide(level, secondPos, secondState, direction);
            if (wallSide == null) {
                wallSide = WallSide.LOW;
            }
            firstState = (BlockState)firstState.m_61124_((Property)RoofRidgeBlock.DIRECTION_TO_PROPERTY.get(direction), (Comparable)wallSide);
            firstState = (BlockState)firstState.m_61124_((Property)WallBlock.f_57949_, (Comparable)Boolean.valueOf(this.xkdeco$shouldRaisePost(firstState)));
            cir.setReturnValue((Object)firstState);
        }
    }

    @Unique
    private boolean xkdeco$shouldRaisePost(BlockState state) {
        WallSide wallside = (WallSide)state.m_61143_((Property)WallBlock.f_57951_);
        WallSide wallside1 = (WallSide)state.m_61143_((Property)WallBlock.f_57952_);
        WallSide wallside2 = (WallSide)state.m_61143_((Property)WallBlock.f_57950_);
        WallSide wallside3 = (WallSide)state.m_61143_((Property)WallBlock.f_57953_);
        boolean flag1 = wallside1 == WallSide.NONE;
        boolean flag2 = wallside3 == WallSide.NONE;
        boolean flag3 = wallside2 == WallSide.NONE;
        boolean flag4 = wallside == WallSide.NONE;
        return flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
    }
}

