/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.util;

import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.block.AirDuctBlock;
import org.teacon.xkdeco.block.ItemDisplayBlock;
import org.teacon.xkdeco.block.MimicWallBlock;
import org.teacon.xkdeco.block.OneDirectionFenceGateBlock;
import org.teacon.xkdeco.block.SpecialSlabBlock;
import org.teacon.xkdeco.block.XKDBlock;
import org.teacon.xkdeco.data.XKDDataGen;
import org.teacon.xkdeco.duck.XKDPlayer;
import org.teacon.xkdeco.init.MimicWallsLoader;
import org.teacon.xkdeco.mixin.forge.FenceGateBlockAccess;
import org.teacon.xkdeco.util.ClientProxy;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.loader.Platform;

@Mod(value="xkdeco")
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommonProxy {
    public CommonProxy() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(EventPriority.LOWEST, event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256747_)) {
                MimicWallsLoader.addMimicWalls();
            }
        });
        modEventBus.addListener(event -> {
            if (MimicWallsLoader.STRUCTURE_TAB_KEY.equals((Object)event.getTabKey())) {
                for (Block block : BuiltInRegistries.f_256975_) {
                    if (!(block instanceof MimicWallBlock)) continue;
                    event.m_246326_((ItemLike)block);
                }
            }
        });
        modEventBus.addListener(event -> {
            FabricDataGenerator dataGenerator = FabricDataGenerator.create((String)"xkdeco", (GatherDataEvent)event);
            new XKDDataGen().onInitializeDataGenerator(dataGenerator);
        });
        if (Platform.isPhysicalClient()) {
            ClientProxy.init();
        }
        BlockCodecs.register((ResourceLocation)XKDeco.id("block"), (MapCodec)BlockCodecs.simpleCodec(XKDBlock::new));
        BlockCodecs.register((ResourceLocation)XKDeco.id("special_slab"), SpecialSlabBlock.CODEC);
        BlockCodecs.register((ResourceLocation)XKDeco.id("one_direction_fence_gate"), OneDirectionFenceGateBlock.CODEC);
        BlockCodecs.register((ResourceLocation)XKDeco.id("item_display"), ItemDisplayBlock.CODEC);
    }

    public static boolean isLadder(BlockState blockState, LevelReader world, BlockPos pos) {
        return blockState.isLadder(world, pos, null);
    }

    public static SoundEvent getFenceGateSound(FenceGateBlock block, boolean open) {
        return open ? ((FenceGateBlockAccess)block).getOpenSound() : ((FenceGateBlockAccess)block).getCloseSound();
    }

    public static void moveEntity(XKDPlayer player, Entity entity, Vec3 pPos) {
        BlockPos pos;
        if (entity.f_19794_ || !entity.f_19862_ || entity.f_185931_) {
            return;
        }
        if (!(entity.m_217003_(Pose.STANDING) || entity.m_217003_(Pose.CROUCHING) || entity.m_217003_(Pose.SWIMMING))) {
            return;
        }
        AABB box = entity.m_20191_();
        if (Mth.m_14107_((double)box.f_82291_) != Mth.m_14107_((double)box.f_82288_) && Mth.m_14107_((double)box.f_82293_) != Mth.m_14107_((double)box.f_82290_)) {
            return;
        }
        Direction direction = Direction.m_122366_((double)pPos.f_82479_, (double)0.0, (double)pPos.f_82481_);
        if (Direction.Axis.Y.test(direction)) {
            return;
        }
        Level level = entity.m_9236_();
        BlockState blockState = level.m_8055_(pos = entity.m_20183_().m_121945_(direction));
        if (blockState.m_204336_(XKDBlock.AIR_DUCTS) && AirDuctBlock.isAirDuctSlot(blockState, direction.m_122424_()) && !blockState.m_60783_((BlockGetter)level, pos, direction.m_122424_())) {
            player.xkdeco$collideWithAirDuctHorizontally();
        }
    }

    public static void registerBlock(ResourceLocation id, Block block) {
        ForgeRegistries.BLOCKS.register(id, (Object)block);
    }

    public static void registerItem(ResourceLocation id, Item item) {
        ForgeRegistries.ITEMS.register(id, (Object)item);
    }
}

