/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment;

import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.IHaveIcons;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.VehiclePart;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractCompartmentEntity
extends Entity
implements IHaveIcons {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(AbstractCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURT_DIR = SynchedEntityData.m_135353_(AbstractCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(AbstractCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final float DAMAGE_TO_BREAK = 10.0f;
    private static final float DAMAGE_RECOVERY = 0.5f;
    public int lifespan = 6000;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    @Nullable
    protected VehiclePart ridingThisPart = null;
    protected int vehiclePassengerIndex = -1;
    private int notRidingTicks = 0;

    public AbstractCompartmentEntity(CompartmentType<? extends AbstractCompartmentEntity> compartmentType, Level level) {
        super(compartmentType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURT_DIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected AbstractCompartmentEntity swapCompartments(AbstractCompartmentEntity newCompartment) {
        this.m_5552_(this.getDropStack(), 1.0f);
        this.m_8127_();
        this.m_146870_();
        newCompartment.m_146922_(this.m_146908_());
        newCompartment.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        newCompartment.ridingThisPart = this.ridingThisPart;
        assert (this.ridingThisPart != null);
        newCompartment.m_20329_(this.ridingThisPart);
        this.m_9236_().m_7967_((Entity)newCompartment);
        return newCompartment;
    }

    public void m_8119_() {
        AbstractVehicle vehicle;
        Entity entity;
        if (this.ridingThisPart == null && this.m_20159_() && this.m_20202_() instanceof VehiclePart) {
            this.ridingThisPart = (VehiclePart)this.m_20202_();
        }
        if (this.vehiclePassengerIndex == -1 && this.m_20159_() && (entity = this.m_20201_()) instanceof AbstractVehicle && (vehicle = (AbstractVehicle)entity).m_20197_().size() == vehicle.getMaxPassengers()) {
            this.vehiclePassengerIndex = vehicle.m_20197_().indexOf(this.m_20202_());
        }
        if (!this.m_20159_()) {
            this.vehiclePassengerIndex = -1;
            this.m_20101_();
            if (!(this instanceof EmptyCompartmentEntity)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                if (this.m_20069_()) {
                    if (this.getFluidTypeHeight(this.getEyeInFluidType()) > (double)this.m_20192_() - 0.25) {
                        this.m_20334_(0.0, this.getBuoyancy(), 0.0);
                    }
                    if (!this.m_20096_()) {
                        this.m_146922_(this.m_146908_() + 0.4f);
                    }
                }
                if (!this.m_20096_() || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    float f1 = 0.98f;
                    this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
                    if (this.m_20096_()) {
                        Vec3 vec31 = this.m_20184_();
                        if (vec31.f_82480_ < 0.0) {
                            this.m_20256_(vec31.m_82542_(1.0, -0.5, 1.0));
                        }
                    }
                }
                if (!this.m_9236_().m_5776_()) {
                    ++this.notRidingTicks;
                    if (this.notRidingTicks > this.lifespan) {
                        this.m_5552_(this.getDropStack(), 1.0f);
                        this.m_146870_();
                    }
                }
                this.m_20073_();
            } else if (!this.m_9236_().m_5776_()) {
                ++this.notRidingTicks;
                if (this.notRidingTicks > 1) {
                    this.m_5552_(this.getDropStack(), 1.0f);
                    this.m_146870_();
                }
            }
        } else if (this.m_9236_().m_5776_()) {
            this.notRidingTicks = 0;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 0.5f);
        }
        super.m_8119_();
        this.tickLerp();
    }

    protected void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
    }

    public void m_6453_(double posX, double posY, double posZ, float yaw, float pitch, int pPosRotationIncrements, boolean teleport) {
        this.lerpX = posX;
        this.lerpY = posY;
        this.lerpZ = posZ;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public boolean m_6673_(DamageSource pSource) {
        if (pSource.m_269533_(DamageTypeTags.f_268415_)) {
            return true;
        }
        return super.m_6673_(pSource);
    }

    public boolean everyNthTickUnique(int n) {
        return CommonHelper.everyNthTickUnique(this.m_19879_(), this.f_19797_, n);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean instantKill;
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        if (this.m_6673_(damageSource)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + amount * 5.0f);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        boolean bl = instantKill = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_;
        if (!instantKill && !(this.getDamage() > 10.0f)) {
            this.onHurt(damageSource);
            return true;
        }
        this.m_20153_();
        if (!instantKill || this.m_8077_()) {
            this.destroy(damageSource);
        }
        this.m_146870_();
        return true;
    }

    protected void destroy(DamageSource damageSource) {
        this.m_6074_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemStack = this.getDropStack();
            if (this.m_8077_()) {
                itemStack.m_41714_(this.m_7770_());
            }
            Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)CommonHelper.maxHeightOfCollidableEntities(this), (double)this.m_20189_(), (ItemStack)itemStack);
        }
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.lifespan = compoundTag.m_128451_("Lifespan");
        this.notRidingTicks = compoundTag.m_128451_("notRidingTicks");
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("Lifespan", this.lifespan);
        compoundTag.m_128405_("notRidingTicks", this.notRidingTicks);
    }

    public double getBuoyancy() {
        return -0.01;
    }

    public double m_6049_() {
        return 0.125;
    }

    @Nullable
    public AbstractVehicle getTrueVehicle() {
        Entity entity = this.m_20201_();
        if (entity instanceof AbstractVehicle) {
            AbstractVehicle vehicle = (AbstractVehicle)entity;
            return vehicle;
        }
        return null;
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setDamage(float damageTaken) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtTime(int hurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)hurtTime);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT_DIR);
    }

    public void setHurtDir(int pHurtDirection) {
        this.f_19804_.m_135381_(DATA_ID_HURT_DIR, (Object)pHurtDirection);
    }

    public RidingPose getRidingPose() {
        return RidingPose.STANDARD;
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        ArrayList<IngameOverlays.IconState> states = new ArrayList<IngameOverlays.IconState>();
        return states;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (!this.m_9236_().f_46443_ && removalReason.m_146965_()) {
            this.onBreak();
        }
        super.m_142687_(removalReason);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean shouldFaceOtherWay() {
        return false;
    }

    public int getCompartmentBlockLight() {
        return 0;
    }

    protected abstract ItemStack getDropStack();

    @Nullable
    public abstract ItemStack m_142340_();

    protected abstract void onPlaced();

    protected abstract void onHurt(DamageSource var1);

    protected abstract void onBreak();

    public void playSound(SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, soundSource, volume, pitch);
        }
    }

    public static enum RidingPose {
        ULTRA_COMPACT,
        COMPACT,
        STANDING,
        STANDARD;

    }
}

