/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.CompartmentCloneable;
import com.alekiponi.alekiships.util.CommonHelper;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class ContainerCompartmentEntity
extends AbstractCompartmentEntity
implements Container,
CompartmentCloneable {
    public static final String CUSTOM_NAME_KEY = "CustomName";
    protected final int slotCount;
    protected final NonNullList<ItemStack> itemStacks;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::createItemHandler);

    protected ContainerCompartmentEntity(CompartmentType<? extends ContainerCompartmentEntity> compartmentType, Level level, int slotCount) {
        super(compartmentType, level);
        this.slotCount = slotCount;
        this.itemStacks = NonNullList.m_122780_((int)slotCount, (Object)ItemStack.f_41583_);
    }

    protected ContainerCompartmentEntity(CompartmentType<? extends ContainerCompartmentEntity> compartmentType, Level level, int slotCount, ItemStack itemStack) {
        this(compartmentType, level, slotCount);
        CompoundTag blockEntityTag;
        if (itemStack.m_41788_()) {
            this.m_6593_(itemStack.m_41786_());
        }
        if ((blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack)) != null) {
            this.loadFromStackNBT(blockEntityTag);
        }
    }

    protected void loadFromStackNBT(CompoundTag compoundTag) {
        this.readContents(compoundTag);
        if (compoundTag.m_128425_(CUSTOM_NAME_KEY, 8)) {
            this.m_6593_((Component)Component.Serializer.m_130701_((String)compoundTag.m_128461_(CUSTOM_NAME_KEY)));
        }
    }

    @Override
    public CompoundTag saveForItemStack() {
        CompoundTag compoundTag = new CompoundTag();
        this.saveContents(compoundTag);
        if (this.m_8077_()) {
            compoundTag.m_128359_(CUSTOM_NAME_KEY, Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
        return compoundTag;
    }

    @Override
    protected void destroy(DamageSource damageSource) {
        Entity entity;
        super.destroy(damageSource);
        if (!this.m_9236_().f_46443_ && (entity = damageSource.m_7640_()) != null && entity.m_6095_() == EntityType.f_20532_) {
            PiglinAi.m_34873_((Player)((Player)entity), (boolean)true);
        }
    }

    @Override
    protected void onBreak() {
        CommonHelper.dropContents(this.m_9236_(), this.m_20185_(), CommonHelper.maxHeightOfCollidableEntities(this), this.m_20189_(), this);
    }

    public boolean m_6542_(Player player) {
        return !this.m_213877_() && this.m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }

    public void m_5785_(Player player) {
        this.m_9236_().m_214171_(GameEvent.f_157802_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.saveContents(compoundTag);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.readContents(compoundTag);
    }

    protected void saveContents(CompoundTag compoundTag) {
        ContainerHelper.m_18976_((CompoundTag)compoundTag, this.itemStacks, (boolean)false);
    }

    protected void readContents(CompoundTag compoundTag) {
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.itemStacks);
    }

    public void m_6596_() {
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    public final int m_6643_() {
        return this.slotCount;
    }

    public ItemStack m_7407_(int slotIndex, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.itemStacks, (int)slotIndex, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int slotIndex) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)slotIndex);
    }

    public void m_6836_(int slotIndex, ItemStack itemStack) {
        this.itemStacks.set(slotIndex, (Object)itemStack);
        if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public ItemStack m_8020_(int slotIndex) {
        return (ItemStack)this.itemStacks.get(slotIndex);
    }

    public SlotAccess m_141942_(final int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return ContainerCompartmentEntity.this.m_8020_(slotIndex);
            }

            public boolean m_142104_(ItemStack itemStack) {
                ContainerCompartmentEntity.this.m_6836_(slotIndex, itemStack);
                return true;
            }
        } : SlotAccess.f_147290_;
    }

    public boolean m_7983_() {
        return this.itemStacks.stream().allMatch(ItemStack::m_41619_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(this::createItemHandler);
    }

    protected IItemHandler createItemHandler() {
        return new InvWrapper((Container)this);
    }

    public static abstract class ContainerMenuCompartmentEntity
    extends ContainerCompartmentEntity
    implements MenuProvider {
        protected ContainerMenuCompartmentEntity(CompartmentType<? extends ContainerMenuCompartmentEntity> compartmentType, Level level, int slotCount) {
            super(compartmentType, level, slotCount);
        }

        protected ContainerMenuCompartmentEntity(CompartmentType<? extends ContainerMenuCompartmentEntity> compartmentType, Level level, int slotCount, ItemStack itemStack) {
            super(compartmentType, level, slotCount, itemStack);
        }

        public InteractionResult m_6096_(Player player, InteractionHand hand) {
            player.m_5893_((MenuProvider)this);
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return this.createMenu(id, inventory);
        }

        protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);
    }
}

