/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.LidCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.SimpleBlockMenuCompartment;
import com.alekiponi.alekiships.util.CommonHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class EnderChestCompartmentEntity
extends AbstractCompartmentEntity
implements SimpleBlockMenuCompartment,
LidCompartment {
    public static final byte CONTAINER_OPEN = 1;
    public static final byte CONTAINER_CLOSE = 2;
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.enderchest");
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            EnderChestCompartmentEntity.this.playSound(SoundEvents.f_11889_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            EnderChestCompartmentEntity.this.playSound(SoundEvents.f_11888_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int count, int openCount) {
            EnderChestCompartmentEntity.this.signalOpenCount(level, (byte)openCount);
        }

        protected boolean m_142718_(Player player) {
            return false;
        }
    };

    public EnderChestCompartmentEntity(CompartmentType<? extends EnderChestCompartmentEntity> compartmentType, Level level) {
        super(compartmentType, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.chestLidController.m_155374_();
        if (!this.m_213877_() && this.m_9236_().m_5776_()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
            this.openersCounter.m_155476_(this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    public void m_7822_(byte dataID) {
        switch (dataID) {
            case 1: {
                this.chestLidController.m_155377_(true);
                break;
            }
            case 2: {
                this.chestLidController.m_155377_(false);
            }
        }
        super.m_7822_(dataID);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        player.m_5893_(this.getMenuProvider());
        this.m_146852_(GameEvent.f_157803_, (Entity)player);
        player.m_36220_(Stats.f_12963_);
        PiglinAi.m_34873_((Player)player, (boolean)true);
        return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
    }

    public void startOpen(Player player) {
        if (!this.m_213877_() && !player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155452_(player, this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.m_213877_() && !player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155468_(player, this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public float getOpenNess(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    private void signalOpenCount(Level level, byte openCount) {
        level.m_7605_((Entity)this, openCount > 0 ? (byte)1 : 2);
    }

    @Override
    protected void onPlaced() {
        CommonHelper.playPlaceSound(this::playSound, SoundType.f_56742_);
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        CommonHelper.playHitSound(this::playSound, SoundType.f_56742_);
    }

    @Override
    protected void onBreak() {
        CommonHelper.playBreakSound(this::playSound, SoundType.f_56742_);
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)Blocks.f_50265_);
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Blocks.f_50265_);
    }

    @Override
    public int getCompartmentBlockLight() {
        return 7;
    }

    @Override
    public double getBuoyancy() {
        return -0.02;
    }

    @Override
    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider(this::createMenu, CONTAINER_TITLE);
    }

    private AbstractContainerMenu createMenu(int id, Inventory playerInventory, final Player player) {
        class EnderChestContainerWrapper
        extends SimpleContainer {
            private final PlayerEnderChestContainer enderChestInventory;

            EnderChestContainerWrapper() {
                super(new ItemStack[0]);
                this.enderChestInventory = player.m_36327_();
            }

            public ItemStack m_8020_(int slotIndex) {
                return this.enderChestInventory.m_8020_(slotIndex);
            }

            public List<ItemStack> m_19195_() {
                return this.enderChestInventory.m_19195_();
            }

            public ItemStack m_7407_(int slotIndex, int count) {
                return this.enderChestInventory.m_7407_(slotIndex, count);
            }

            public ItemStack m_19170_(Item item, int amount) {
                return this.enderChestInventory.m_19170_(item, amount);
            }

            public ItemStack m_19173_(ItemStack itemStack) {
                return this.enderChestInventory.m_19173_(itemStack);
            }

            public boolean m_19183_(ItemStack itemStack) {
                return this.enderChestInventory.m_19183_(itemStack);
            }

            public ItemStack m_8016_(int slotIndex) {
                return this.enderChestInventory.m_8016_(slotIndex);
            }

            public void m_6836_(int slotIndex, ItemStack itemStack) {
                this.enderChestInventory.m_6836_(slotIndex, itemStack);
            }

            public int m_6643_() {
                return this.enderChestInventory.m_6643_();
            }

            public boolean m_7983_() {
                return this.enderChestInventory.m_7983_();
            }

            public void m_6596_() {
                this.enderChestInventory.m_6596_();
            }

            public boolean m_6542_(Player player2) {
                return CommonHelper.stillValidEntity(EnderChestCompartmentEntity.this, player2) && super.m_6542_(player2);
            }

            public void m_6211_() {
                this.enderChestInventory.m_6211_();
            }

            public void m_5809_(StackedContents stackedContents) {
                this.enderChestInventory.m_5809_(stackedContents);
            }

            public String toString() {
                return this.enderChestInventory.toString();
            }

            public void m_7797_(ListTag containerNBT) {
                this.enderChestInventory.m_7797_(containerNBT);
            }

            public ListTag m_7927_() {
                return this.enderChestInventory.m_7927_();
            }

            public void m_5856_(Player player2) {
                EnderChestCompartmentEntity.this.startOpen(player2);
                super.m_5856_(player2);
            }

            public void m_5785_(Player player2) {
                EnderChestCompartmentEntity.this.stopOpen(player2);
                super.m_5785_(player2);
            }
        }
        return ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)new EnderChestContainerWrapper());
    }
}

