/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data;

import com.alekiponi.alekiships.data.providers.AlekiShipsAdvancementsProvider;
import com.alekiponi.alekiships.data.providers.AlekiShipsLanguageProvider;
import com.alekiponi.alekiships.data.providers.AlekiShipsLootTableProvider;
import com.alekiponi.alekiships.data.providers.AlekiShipsRecipeProvider;
import com.alekiponi.alekiships.data.providers.models.AlekiShipsBlockStateProvider;
import com.alekiponi.alekiships.data.providers.models.AlekiShipsItemModelProvider;
import com.alekiponi.alekiships.data.providers.tags.AlekiShipsBlockTagsProvider;
import com.alekiponi.alekiships.data.providers.tags.AlekiShipsEntityTypeTagsProvider;
import com.alekiponi.alekiships.data.providers.tags.AlekiShipsItemTagsProvider;
import com.alekiponi.alekiships.data.providers.tags.AlekiShipsStructureTagProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="alekiships", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        AlekiShipsBlockTagsProvider blockTags = new AlekiShipsBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new AlekiShipsItemTagsProvider(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AlekiShipsEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AlekiShipsStructureTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AlekiShipsRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)AlekiShipsLootTableProvider.create(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)AlekiShipsAdvancementsProvider.create(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AlekiShipsLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new AlekiShipsItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AlekiShipsBlockStateProvider(packOutput, existingFileHelper));
    }
}

