/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.events;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveAnchorWindlass;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveSailSwitches;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CleatEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.SailSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.WindlassSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="alekiships", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    public static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_7654_().m_129792_() && player.m_9236_().m_7654_().m_7779_(player.m_36316_())) {
            EmptyCompartmentEntity compartment;
            AbstractVehicle vehicle;
            Entity entity = player.m_20202_();
            if (entity instanceof EmptyCompartmentEntity && (vehicle = (compartment = (EmptyCompartmentEntity)entity).getTrueVehicle()) != null) {
                player.m_5618_(vehicle.m_146908_());
                player.m_5616_(vehicle.m_146908_());
                player.m_146922_(vehicle.m_146908_());
            }
        } else {
            Entity compartment = player.m_20202_();
            if (compartment instanceof EmptyCompartmentEntity) {
                Object players;
                Object boat;
                Entity vehicle;
                EmptyCompartmentEntity compartment2 = (EmptyCompartmentEntity)compartment;
                player.m_8127_();
                player.m_146884_(compartment2.m_20201_().m_7688_((LivingEntity)player));
                if (compartment2.m_20159_() && (vehicle = compartment2.m_20201_()) instanceof IHaveSailSwitches) {
                    boat = (IHaveSailSwitches)vehicle;
                    players = ((AbstractVehicle)boat).collectPlayerPassengers();
                    players.addAll(((AbstractVehicle)boat).collectPlayersToTakeWith());
                    if (players.size() == 1) {
                        for (SailSwitchEntity sail : boat.getSailSwitches()) {
                            sail.setSwitched(false);
                        }
                    }
                }
                if (compartment2.m_20159_() && (players = compartment2.m_20201_()) instanceof IHaveAnchorWindlass) {
                    boat = (IHaveAnchorWindlass)players;
                    players = ((AbstractVehicle)boat).collectPlayerPassengers();
                    players.addAll(((AbstractVehicle)boat).collectPlayersToTakeWith());
                    if (players.size() == 1) {
                        for (WindlassSwitchEntity windlass : boat.getWindlasses()) {
                            windlass.setSwitched(true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!living.m_20159_()) {
            return;
        }
        if (!(living.m_20202_() instanceof EmptyCompartmentEntity)) {
            return;
        }
        if (!event.getEntity().m_36341_()) {
            return;
        }
        living.m_8127_();
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (!(target instanceof AbstractCompartmentEntity)) {
            return;
        }
        if (target instanceof EmptyCompartmentEntity) {
            return;
        }
        Player player = event.getEntity();
        double attackDamage = player.m_21133_(Attributes.f_22281_);
        if (target.m_6469_(player.m_269291_().m_269075_(player), (float)attackDamage)) {
            player.m_21335_(target);
            player.m_36399_(0.1f);
        }
        player.m_36334_();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268612_) && event.getEntity().m_20202_() instanceof EmptyCompartmentEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_204336_(BlockTags.f_13039_)) {
            return;
        }
        Player player = event.getEntity();
        LeashFenceKnotEntity knotEntity = null;
        boolean leashedSomething = false;
        for (CleatEntity cleat : level.m_45976_(CleatEntity.class, new AABB((double)(blockPos.m_123341_() - 7), (double)(blockPos.m_123342_() - 7), (double)(blockPos.m_123343_() - 7), (double)(blockPos.m_123341_() + 7), (double)(blockPos.m_123342_() + 7), (double)(blockPos.m_123343_() + 7)))) {
            if (cleat.getLeashHolder() != player) continue;
            if (knotEntity == null) {
                knotEntity = LeashFenceKnotEntity.m_31844_((Level)level, (BlockPos)blockPos);
                knotEntity.m_7084_();
            }
            cleat.setLeashedTo((Entity)knotEntity, true);
            leashedSomething = true;
        }
        if (leashedSomething) {
            level.m_220407_(GameEvent.f_157791_, blockPos, GameEvent.Context.m_223717_((Entity)player));
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
    }
}

