/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.light.headlamp;

import com.kipti.bnb.content.light.founation.LightBlock;
import com.kipti.bnb.content.light.headlamp.HeadlampBlockEntity;
import com.kipti.bnb.registry.BnbBlockEntities;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadlampBlock
extends LightBlock
implements IBE<HeadlampBlockEntity> {
    public HeadlampBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_, BnbShapes.LIGHTBULB_SHAPE);
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        Vec3 location = HeadlampBlock.getPlayerLocationInBlock(pos, placer);
        this.withBlockEntityDo((BlockGetter)level, pos, headlampBlockEntity -> headlampBlockEntity.placeHeadlampIntoBlock(location.m_82546_(pos.m_252807_()), (Direction)state.m_61143_((Property)f_52588_)));
    }

    @NotNull
    private static Vec3 getPlayerLocationInBlock(BlockPos pos, @NotNull LivingEntity placer) {
        double range = 10.0;
        HitResult hitResult = placer.m_19907_(range, 1.0f, false);
        Vec3 location = hitResult.m_82450_();
        Vec3 direction = placer.m_20154_();
        AABB hitBox = new AABB(pos);
        location = hitBox.m_82371_(location.m_82549_(direction.m_82490_(2.0)), location).orElse(location);
        return location;
    }

    private Vec3 getPlayerLocationInBlockExact(BlockPos pos, Level level, @NotNull LivingEntity placer) {
        double range = 10.0;
        HitResult hitResult = placer.m_19907_(range, 1.0f, false);
        Vec3 location = hitResult.m_82450_();
        Vec3 direction = placer.m_20154_();
        BlockHitResult clip = level.m_8055_(pos).m_60808_((BlockGetter)level, pos).m_83220_(location, direction.m_82490_(2.0), pos);
        if (clip == null) {
            return location;
        }
        return clip.m_82450_();
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext useContext) {
        BlockItem blockItem;
        if (useContext.m_7078_()) {
            return false;
        }
        ItemStack stack = useContext.m_43722_();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() != this) {
            return super.m_6864_(state, useContext);
        }
        Vec3 location = useContext.m_43720_();
        BlockPos pos = useContext.m_8083_();
        BlockEntity blockEntity = useContext.m_43725_().m_7702_(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            return headlampBlockEntity.canPlaceHeadlampIntoBlock(location.m_82546_(pos.m_252807_()), (Direction)state.m_61143_((Property)f_52588_));
        }
        return super.m_6864_(state, useContext);
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        HeadlampBlockEntity fpbe = (HeadlampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        Vec3 location = pContext.m_43720_().m_82546_(pos.m_252807_());
        Direction facing = (Direction)stateForPlacement.m_61143_((Property)f_52588_);
        if (blockState.m_60713_((Block)this) && location != null && fpbe != null) {
            if (!level.m_5776_()) {
                Vec3 finalLocation = location;
                this.withBlockEntityDo((BlockGetter)level, pos, headlampBlockEntity -> headlampBlockEntity.placeHeadlampIntoBlock(finalLocation, facing));
                level.m_247517_(null, pos, this.f_60446_.m_56777_(), SoundSource.BLOCKS);
            }
            stateForPlacement = blockState;
        }
        return stateForPlacement;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        ItemStack stack = player.m_21120_(interactionHand);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof HeadlampBlockEntity) {
                HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
                headlampBlockEntity.placeDyeColorIntoBlock(dyeItem.m_41089_(), blockHitResult.m_82450_().m_82546_(blockPos.m_252807_()), (Direction)blockState.m_61143_((Property)f_52588_));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        HeadlampBlockEntity headlampBlockEntity;
        BlockEntity blockEntity;
        Vec3 location = this.getPlayerLocationInBlockExact(pos, level, (LivingEntity)player);
        if (!player.m_6047_() && (blockEntity = level.m_7702_(pos)) instanceof HeadlampBlockEntity && (headlampBlockEntity = (HeadlampBlockEntity)blockEntity).removeNearestHeadlamp(location.m_82546_(pos.m_252807_()), (Direction)state.m_61143_((Property)f_52588_))) {
            if (!level.f_46443_ && !player.m_7500_()) {
                HeadlampBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)BnbBlocks.HEADLAMP.asStack());
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        if (newState != null && newState.m_60713_(state.m_60734_())) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            ItemStack additionalResources = BnbBlocks.HEADLAMP.asStack().m_255036_(Math.min(Math.max(headlampBlockEntity.getExistingPlacements().size() - 1, 0), 3));
            if (!additionalResources.m_41619_()) {
                HeadlampBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)additionalResources);
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        HeadlampBlockEntity headlampBlockEntity;
        Vec3 location = this.getPlayerLocationInBlockExact(context.m_8083_(), context.m_43725_(), (LivingEntity)context.m_43723_());
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof HeadlampBlockEntity && (headlampBlockEntity = (HeadlampBlockEntity)blockEntity).removeNearestHeadlamp(location.m_82546_(context.m_8083_().m_252807_()), (Direction)state.m_61143_((Property)f_52588_))) {
            if (!context.m_43725_().f_46443_ && !context.m_43723_().m_7500_()) {
                context.m_43723_().m_36356_(BnbBlocks.HEADLAMP.asStack());
            }
            IWrenchable.playRemoveSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            voxelShape = headlampBlockEntity.getShape(state, level, pos, context);
        } else {
            voxelShape = Shapes.m_83144_();
        }
        return voxelShape;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)super.m_6843_(state, rotation).m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public boolean m_49967_() {
        return true;
    }

    public Class<HeadlampBlockEntity> getBlockEntityClass() {
        return HeadlampBlockEntity.class;
    }

    public BlockEntityType<? extends HeadlampBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BnbBlockEntities.HEADLAMP.get();
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return super.m_5909_(state, level, pos, context);
    }
}

