/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.forge;

import com.furiusmax.bjornlib.forge.PlayerMorphCapability;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;

public class SyncPlayerMorphToClient {
    CompoundTag tag;
    UUID sender;

    public SyncPlayerMorphToClient(CompoundTag tag, UUID sender) {
        this.tag = tag;
        this.sender = sender;
    }

    public static void encode(SyncPlayerMorphToClient msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.tag);
        buf.m_130077_(msg.sender);
    }

    public static SyncPlayerMorphToClient decode(FriendlyByteBuf buf) {
        return new SyncPlayerMorphToClient(buf.m_130260_(), buf.m_130259_());
    }

    public static void handle(SyncPlayerMorphToClient msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Optional optionalLevel = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide());
            optionalLevel.ifPresent(level -> {
                for (Player sp : level.m_6907_()) {
                    PlayerMorphCapability playerData;
                    if (!sp.m_20148_().equals(msg.sender) || (playerData = (PlayerMorphCapability)sp.getCapability(PlayerMorphCapability.MORPH).orElse(null)) == null) continue;
                    playerData.setMorph(null);
                    playerData.deserializeNBT(msg.tag);
                    sp.m_6210_();
                }
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

