/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.misc.client.lightning;

import com.furiusmax.bjornlib.util.BjornLibUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class LightningBuilder {
    public static Builder create(Vec3 viewVector, Vec3 rayStart) {
        return new Builder(viewVector, rayStart);
    }

    public static class Builder {
        List<Vec3> rayPositions;
        Entity entityOwner;
        int parts;
        int divisionCount = 0;
        int r1;
        int g1;
        int b1;
        int a1;
        int r2;
        int g2;
        int b2;
        int a2;
        float renderDelay;
        float innerSize;
        float middleSize;
        float outterSize;
        float randomOffset;
        float divisionRandomOffset;
        Vec3 viewVectorDistance;
        Vec3 rayStart;

        protected Builder(Vec3 viewVectorDistance, Vec3 rayStart) {
            this.viewVectorDistance = viewVectorDistance;
            this.rayStart = rayStart;
        }

        public Builder setOwner(Entity owner) {
            this.entityOwner = owner;
            return this;
        }

        public Builder setParts(int parts) {
            this.parts = parts;
            return this;
        }

        public Builder setdivisionCount(int divisionCount) {
            this.divisionCount = divisionCount;
            return this;
        }

        public Builder setmiddleColor(int r, int g, int b, int a) {
            this.r1 = r;
            this.g1 = g;
            this.b1 = b;
            this.a1 = a;
            return this;
        }

        public Builder setOutterColor(int r, int g, int b, int a) {
            this.r2 = r;
            this.g2 = g;
            this.b2 = b;
            this.a2 = a;
            return this;
        }

        public Builder setDelay(float delay) {
            this.renderDelay = delay;
            return this;
        }

        public Builder setSize(float innerSize, float middleSize, float outterSize) {
            this.innerSize = innerSize;
            this.middleSize = middleSize;
            this.outterSize = outterSize;
            return this;
        }

        public Builder setPositionList(List<Vec3> list) {
            this.rayPositions = list;
            return this;
        }

        public Builder setRandomOffset(float offset) {
            this.randomOffset = offset;
            return this;
        }

        public Builder setDivisionRandomOffset(float offset) {
            this.divisionRandomOffset = offset;
            return this;
        }

        public Builder renderLightning(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource) {
            poseStack.m_85836_();
            poseStack.m_85837_(this.viewVectorDistance.f_82479_, this.viewVectorDistance.f_82480_, this.viewVectorDistance.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_146909_()));
            if ((float)entity.f_19797_ % this.renderDelay == 0.0f) {
                this.genRay(entity, this.rayStart, this.rayPositions);
            }
            for (int i = 0; i < this.rayPositions.size() - 1; i += 2) {
                Vec3 from = this.rayPositions.get(i);
                Vec3 to = this.rayPositions.get(i + 1);
                BjornLibUtil.renderHull(from, to, this.outterSize, this.outterSize, poseStack, bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)new ResourceLocation("bjornlib", "textures/solid.png"))), this.r2, this.g2, this.b2, this.a2);
                BjornLibUtil.renderHull(from, to, this.middleSize, this.middleSize, poseStack, bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)new ResourceLocation("bjornlib", "textures/solid.png"))), this.r1, this.g1, this.b1, this.a1);
                BjornLibUtil.renderHull(from, to, this.innerSize, this.innerSize, poseStack, bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)new ResourceLocation("bjornlib", "textures/solid.png"), (float)0.0f, (float)0.0f)), 255, 255, 255, 255);
            }
            poseStack.m_85849_();
            return this;
        }

        private void genRay(Entity entity, Vec3 randomStart, List<Vec3> list) {
            BlockHitResult hitResult;
            list.clear();
            Random random = new Random();
            Vec3 start = randomStart;
            Vec3 end = Vec3.f_82478_;
            int parts = this.parts;
            Optional<Entity> entityHitResult = BjornLibUtil.getTargetedEntity(this.entityOwner, 10, 1.0);
            if (entityHitResult.isPresent()) {
                parts = Math.min(parts, (int)entity.m_20270_(entityHitResult.get()) + 1);
            }
            if ((hitResult = BjornLibUtil.getBlockHitResult(entity.m_9236_(), entity, 10.0, ClipContext.Block.COLLIDER)) != null) {
                parts = (int)Math.min((float)parts, Mth.m_14116_((float)((float)hitResult.m_82448_(entity) - 1.0f)));
            }
            for (int i = 0; i < parts; ++i) {
                list.add(start);
                end = start.m_82520_(0.0, 0.0, 1.0).m_82549_(BjornLibUtil.randomOffset(this.randomOffset, this.randomOffset, this.randomOffset).m_82542_(1.5, 1.0, 1.5));
                list.add(end);
                start = end;
                if (this.divisionCount <= 0) continue;
                list.addAll(this.addExtraRays(end, this.divisionCount, 1, 0.7f));
            }
        }

        public List<Vec3> addExtraRays(Vec3 start, int length, int tries, float prob) {
            ArrayList<Vec3> parts = new ArrayList<Vec3>();
            Random random = new Random();
            float blength = 0.75f / (float)(tries + 1);
            int maxBranches = random.nextInt(length + 1);
            Vec3 newStart = start;
            int direction = random.nextBoolean() ? -1 : 1;
            for (int i = 0; i < maxBranches; ++i) {
                Vec3 end = newStart.m_82520_((double)((float)direction * blength), 0.0, (double)blength).m_82549_(BjornLibUtil.randomOffset(this.divisionRandomOffset, this.divisionRandomOffset, this.divisionRandomOffset));
                parts.add(newStart);
                parts.add(end);
                if (random.nextFloat() <= prob) {
                    parts.addAll(this.addExtraRays(end, length - 1, tries + 1, prob * 1.2f));
                }
                newStart = end;
            }
            return parts;
        }

        public Builder renderLightning(Camera camera, BlockPos pos, float xRot, float yRot, int tickCount, PoseStack poseStack, MultiBufferSource bufferSource) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - camera.m_90592_().m_20185_(), (double)pos.m_123342_() - camera.m_90592_().m_20186_(), (double)pos.m_123343_() - camera.m_90592_().m_20189_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRot));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
            if ((float)tickCount % this.renderDelay == 0.0f) {
                this.genRay(this.rayStart, this.rayPositions);
            }
            for (int i = 0; i < this.rayPositions.size() - 1; i += 2) {
                Vec3 from = this.rayPositions.get(i);
                Vec3 to = this.rayPositions.get(i + 1);
                BjornLibUtil.renderHull(from, to, this.outterSize, this.outterSize, poseStack, bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)new ResourceLocation("bjornlib", "textures/solid.png"))), this.r2, this.g2, this.b2, this.a2);
                BjornLibUtil.renderHull(from, to, this.middleSize, this.middleSize, poseStack, bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)new ResourceLocation("bjornlib", "textures/solid.png"))), this.r1, this.g1, this.b1, this.a1);
                BjornLibUtil.renderHull(from, to, this.innerSize, this.innerSize, poseStack, bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)new ResourceLocation("bjornlib", "textures/solid.png"), (float)0.0f, (float)0.0f)), 255, 255, 255, 255);
            }
            poseStack.m_85849_();
            return this;
        }

        private void genRay(Vec3 randomStart, List<Vec3> list) {
            list.clear();
            Random random = new Random();
            Vec3 start = randomStart;
            Vec3 end = Vec3.f_82478_;
            int parts = this.parts;
            for (int i = 0; i < parts; ++i) {
                list.add(start);
                end = start.m_82520_(0.0, 0.0, 1.0).m_82549_(BjornLibUtil.randomOffset(this.randomOffset, this.randomOffset, this.randomOffset).m_82542_(1.5, 1.0, 1.5));
                list.add(end);
                start = end;
                if (this.divisionCount <= 0) continue;
                list.addAll(this.addExtraRays(end, this.divisionCount, 1, 0.7f));
            }
        }
    }
}

