/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.misc.client.particle;

import com.furiusmax.bjornlib.client.particle.GenericParticleData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleBuilder {
    public static Builder create(ParticleType<?> type) {
        return new Builder(type);
    }

    public static class Builder {
        static Random random = new Random();
        ParticleType<?> type;
        GenericParticleData data;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double maxXSpeed = 0.0;
        double maxYSpeed = 0.0;
        double maxZSpeed = 0.0;
        double maxXDist = 0.0;
        double maxYDist = 0.0;
        double maxZDist = 0.0;
        boolean force = false;

        protected Builder(ParticleType<?> type) {
            this.type = type;
            this.data = new GenericParticleData(type);
        }

        public Builder alwaysVisible() {
            this.force = true;
            return this;
        }

        public Builder setColor(float r, float g, float b) {
            this.setColor(r, g, b, this.data.a1, r, g, b, this.data.a2);
            return this;
        }

        public Builder setColor(float r, float g, float b, float a) {
            this.setColor(r, g, b, a, r, g, b, a);
            return this;
        }

        public Builder setColor(float r, float g, float b, float a1, float a2) {
            this.setColor(r, g, b, a1, r, g, b, a2);
            return this;
        }

        public Builder setColor(float r1, float g1, float b1, float r2, float g2, float b2) {
            this.setColor(r1, g1, b1, this.data.a1, r2, g2, b2, this.data.a2);
            return this;
        }

        public Builder setColor(float r1, float g1, float b1, float r2, float g2, float b2, float a) {
            this.setColor(r1, g1, b1, a, r2, g2, b2, a);
            return this;
        }

        public Builder setColor(float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
            this.data.r1 = r1;
            this.data.g1 = g1;
            this.data.b1 = b1;
            this.data.a1 = a1;
            this.data.r2 = r2;
            this.data.g2 = g2;
            this.data.b2 = b2;
            this.data.a2 = a2;
            return this;
        }

        public Builder setAlpha(float a) {
            this.setAlpha(a, a);
            return this;
        }

        public Builder setOwner(Entity entity) {
            if (entity != null) {
                this.data.ownerUUID = entity.m_20148_().toString();
            }
            return this;
        }

        public Builder setAlpha(float a1, float a2) {
            this.data.a1 = a1;
            this.data.a2 = a2;
            return this;
        }

        public Builder setScale(float scale) {
            this.setScale(scale, scale);
            return this;
        }

        public Builder setScale(float scale1, float scale2) {
            this.data.scale1 = scale1;
            this.data.scale2 = scale2;
            return this;
        }

        public Builder enableGravity() {
            this.data.gravity = true;
            return this;
        }

        public Builder disableGravity() {
            this.data.gravity = false;
            return this;
        }

        public Builder setSpin(float angularVelocity) {
            this.data.spin = angularVelocity;
            return this;
        }

        public Builder setLifetime(int lifetime) {
            this.data.lifetime = lifetime;
            return this;
        }

        public Builder randomVelocity(double maxSpeed) {
            this.randomVelocity(maxSpeed, maxSpeed, maxSpeed);
            return this;
        }

        public Builder randomVelocity(double maxHSpeed, double maxVSpeed) {
            this.randomVelocity(maxHSpeed, maxVSpeed, maxHSpeed);
            return this;
        }

        public Builder randomVelocity(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
            this.maxXSpeed = maxXSpeed;
            this.maxYSpeed = maxYSpeed;
            this.maxZSpeed = maxZSpeed;
            return this;
        }

        public Builder addVelocity(double vx, double vy, double vz) {
            this.vx += vx;
            this.vy += vy;
            this.vz += vz;
            return this;
        }

        public Builder setVelocity(double vx, double vy, double vz) {
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
            return this;
        }

        public Builder randomOffset(double maxDistance) {
            this.randomOffset(maxDistance, maxDistance, maxDistance);
            return this;
        }

        public Builder randomOffset(double maxHDist, double maxVDist) {
            this.randomOffset(maxHDist, maxVDist, maxHDist);
            return this;
        }

        public Builder randomOffset(double maxXDist, double maxYDist, double maxZDist) {
            this.maxXDist = maxXDist;
            this.maxYDist = maxYDist;
            this.maxZDist = maxZDist;
            return this;
        }

        public Builder spawn(Level world, double x, double y, double z) {
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            double zDist = (double)random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            if (this.force) {
                world.m_7107_((ParticleOptions)this.data, x + this.dx, y + this.dy, z + this.dz, this.vx, this.vy, this.vz);
            } else {
                world.m_7106_((ParticleOptions)this.data, x + this.dx, y + this.dy, z + this.dz, this.vx, this.vy, this.vz);
            }
            return this;
        }

        public Builder spawnServer(ServerLevel world, double x, double y, double z, double speed, int count) {
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            double zDist = (double)random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            this.sendParticles((Level)world, this.data, x + this.dx, y + this.dy, z + this.dz, count, this.vx, this.vy, this.vz, speed, this.force);
            return this;
        }

        public Builder repeatServer(ServerLevel world, double x, double y, double z, double speed, int count, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawnServer(world, x, y, z, speed, count);
            }
            return this;
        }

        public Builder repeat(Level world, double x, double y, double z, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawn(world, x, y, z);
            }
            return this;
        }

        public <T extends ParticleOptions> int sendParticles(Level level, T p_8768_, double p_8769_, double p_8770_, double p_8771_, int p_8772_, double p_8773_, double p_8774_, double p_8775_, double p_8776_, boolean alwaysVisible) {
            ClientboundLevelParticlesPacket clientboundlevelparticlespacket = new ClientboundLevelParticlesPacket(p_8768_, alwaysVisible, p_8769_, p_8770_, p_8771_, (float)p_8773_, (float)p_8774_, (float)p_8775_, (float)p_8776_, p_8772_);
            int i = 0;
            for (int j = 0; j < level.m_7654_().m_6846_().m_11314_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)level.m_7654_().m_6846_().m_11314_().get(j);
                if (!this.sendParticles(level, serverplayer, alwaysVisible, p_8769_, p_8770_, p_8771_, (Packet<?>)clientboundlevelparticlespacket)) continue;
                ++i;
            }
            return i;
        }

        public <T extends ParticleOptions> boolean sendParticles(Level level, ServerPlayer p_8625_, T p_8626_, boolean p_8627_, double p_8628_, double p_8629_, double p_8630_, int p_8631_, double p_8632_, double p_8633_, double p_8634_, double p_8635_) {
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(p_8626_, p_8627_, p_8628_, p_8629_, p_8630_, (float)p_8632_, (float)p_8633_, (float)p_8634_, (float)p_8635_, p_8631_);
            return this.sendParticles(level, p_8625_, p_8627_, p_8628_, p_8629_, p_8630_, (Packet<?>)packet);
        }

        private boolean sendParticles(Level level, ServerPlayer p_8637_, boolean p_8638_, double p_8639_, double p_8640_, double p_8641_, Packet<?> p_8642_) {
            if (p_8637_.m_9236_() != level) {
                return false;
            }
            BlockPos blockpos = p_8637_.m_20183_();
            if (blockpos.m_203195_((Position)new Vec3(p_8639_, p_8640_, p_8641_), p_8638_ ? 512.0 : 32.0)) {
                p_8637_.f_8906_.m_9829_(p_8642_);
                return true;
            }
            return false;
        }
    }
}

