/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class BjornLibUtil {
    public static void renderHull(Vec3 from, Vec3 to, float w, float h, PoseStack poseStack, VertexConsumer vertexConsumer, int r, int g, int b, int a) {
        BjornLibUtil.renderQuad(from.m_82492_(0.0, (double)(h * 0.5f), 0.0), to.m_82492_(0.0, (double)(h * 0.5f), 0.0), w, 0.0f, poseStack, vertexConsumer, r, g, b, a);
        BjornLibUtil.renderQuad(from.m_82520_(0.0, (double)(h * 0.5f), 0.0), to.m_82520_(0.0, (double)(h * 0.5f), 0.0), w, 0.0f, poseStack, vertexConsumer, r, g, b, a);
        BjornLibUtil.renderQuad(from.m_82492_((double)(w * 0.5f), 0.0, 0.0), to.m_82492_((double)(w * 0.5f), 0.0, 0.0), 0.0f, h, poseStack, vertexConsumer, r, g, b, a);
        BjornLibUtil.renderQuad(from.m_82520_((double)(w * 0.5f), 0.0, 0.0), to.m_82520_((double)(w * 0.5f), 0.0, 0.0), 0.0f, h, poseStack, vertexConsumer, r, g, b, a);
    }

    private static void renderQuad(Vec3 from, Vec3 to, float w, float h, PoseStack poseStack, VertexConsumer vertexConsumer, int r, int g, int b, int a) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix, (float)from.f_82479_ - w * 0.5f, (float)from.f_82480_ - h * 0.5f, (float)from.f_82481_).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)from.f_82479_ + w * 0.5f, (float)from.f_82480_ + h * 0.5f, (float)from.f_82481_).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)to.f_82479_ + w * 0.5f, (float)to.f_82480_ + h * 0.5f, (float)to.f_82481_).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, (float)to.f_82479_ - w * 0.5f, (float)to.f_82480_ - h * 0.5f, (float)to.f_82481_).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static Player getNearestPlayer(Vec3 position, ServerLevel serverLevel) {
        return serverLevel.m_45924_(position.f_82479_, position.f_82480_, position.f_82481_, -1.0, false);
    }

    public static boolean probably(double percentage) {
        double zeroToOne = Math.random();
        double multiple = zeroToOne * 100.0;
        return multiple < percentage;
    }

    public static double percentValue(double percent, float value) {
        return percent * (double)value / 100.0;
    }

    public static double fractionOfValue(float value, int maxValue) {
        if (value == 0.0f) {
            return 0.0;
        }
        double fraction = (double)value / (double)maxValue;
        return Mth.m_14008_((double)fraction, (double)0.0, (double)1.0);
    }

    public static Vec3 randomOffset(float xRange, float yRange, float zRange) {
        double x = Math.random() * 2.0 * (double)xRange - (double)xRange;
        double y = Math.random() * 2.0 * (double)yRange - (double)yRange;
        double z = Math.random() * 2.0 * (double)zRange - (double)zRange;
        return new Vec3(x, y, z);
    }

    public static Optional<Entity> getTargetedEntity(@Nullable Entity entity, int distance, double offset) {
        int i;
        Predicate<Entity> predicate;
        AABB aabb;
        Vec3 vec31;
        Vec3 vec32;
        if (entity == null) {
            return Optional.empty();
        }
        Vec3 vec3 = entity.m_146892_();
        EntityHitResult entityhitresult = BjornLibUtil.getEntityHitResult(entity, vec3, vec32 = vec3.m_82549_(vec31 = entity.m_20252_(1.0f).m_82490_((double)distance)), aabb = entity.m_20191_().m_82369_(vec31).m_82400_(1.0), predicate = p_113447_ -> !p_113447_.m_5833_() && p_113447_.m_6087_(), i = distance * distance, offset);
        if (entityhitresult == null) {
            return Optional.empty();
        }
        return vec3.m_82557_(entityhitresult.m_82450_()) > (double)i ? Optional.empty() : Optional.of(entityhitresult.m_82443_());
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity p_37288_, Vec3 p_37289_, Vec3 p_37290_, AABB p_37291_, Predicate<Entity> p_37292_, double p_37293_, double offset) {
        Level level = p_37288_.m_9236_();
        double d0 = p_37293_;
        Entity entity = null;
        Vec3 vec3 = null;
        for (Entity entity1 : level.m_6249_(p_37288_, p_37291_, p_37292_)) {
            Vec3 vec31;
            double d1;
            AABB aabb = entity1.m_20191_().m_82400_(offset);
            Optional optional = aabb.m_82371_(p_37289_, p_37290_);
            if (aabb.m_82390_(p_37289_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3 = optional.orElse(p_37289_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_37289_.m_82557_(vec31 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == p_37288_.m_20201_()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3 = vec31;
                continue;
            }
            entity = entity1;
            vec3 = vec31;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vec3);
    }

    public static BlockHitResult getBlockHitResult(Level level, Entity entity, double distance, ClipContext.Block clipContextBlock) {
        float f = entity.m_146909_();
        float f1 = entity.m_146908_();
        Vec3 vec3 = entity.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = vec3.m_82520_((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return level.m_45547_(new ClipContext(vec3, vec31, clipContextBlock, ClipContext.Fluid.NONE, entity));
    }
}

