/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class ShelfCandleBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)6.5, (double)0.0, (double)10.5, (double)9.5, (double)3.0, (double)13.5);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)6.5, (double)0.0, (double)2.5, (double)9.5, (double)3.0, (double)5.5);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)2.5, (double)0.0, (double)6.5, (double)5.5, (double)3.0, (double)9.5);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)10.5, (double)0.0, (double)6.5, (double)13.5, (double)3.0, (double)9.5);
    private static final Vec3 PARTICLE_OFFSET_N = new Vec3(0.5, 0.25, 0.75);
    private static final Vec3 PARTICLE_OFFSET_S = new Vec3(0.5, 0.25, 0.25);
    private static final Vec3 PARTICLE_OFFSET_E = new Vec3(0.25, 0.25, 0.5);
    private static final Vec3 PARTICLE_OFFSET_W = new Vec3(0.75, 0.25, 0.5);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public ShelfCandleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 10 : 0;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (!((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && !((Boolean)pState.m_61143_((Property)SmallFurnitureBlock.WATERLOGGED)).booleanValue()) {
            if (item.m_41720_() instanceof FlintAndSteelItem) {
                if (!pLevel.f_46443_) {
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
                    pLevel.m_247517_(null, pPos, SoundEvents.f_11942_, SoundSource.BLOCKS);
                    if (item.m_41763_()) {
                        item.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (item.m_41619_() && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            if (!pLevel.f_46443_) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
                pLevel.m_247517_(null, pPos, SoundEvents.f_144098_, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            Vec3 offset = this.getOffset(pState);
            float random = pRandom.m_188501_();
            if (random < 0.3f) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pPos.m_123341_() + offset.f_82479_, (double)pPos.m_123342_() + offset.f_82480_, (double)pPos.m_123343_() + offset.f_82481_, 0.0, 0.0, 0.0);
                if (random < 0.17f) {
                    pLevel.m_5594_(null, pPos, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + pRandom.m_188501_(), pRandom.m_188501_() * 0.7f + 0.3f);
                }
            }
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175834_, (double)pPos.m_123341_() + offset.f_82479_, (double)pPos.m_123342_() + offset.f_82480_, (double)pPos.m_123343_() + offset.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private Vec3 getOffset(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.SOUTH -> PARTICLE_OFFSET_S;
            case Direction.EAST -> PARTICLE_OFFSET_E;
            case Direction.WEST -> PARTICLE_OFFSET_W;
            default -> PARTICLE_OFFSET_N;
        };
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            BlockState waterState = (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
                pLevel.m_7731_(pPos, (BlockState)waterState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            } else {
                pLevel.m_7731_(pPos, waterState, 3);
            }
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{LIT});
    }
}

