/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class CrabappleTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CrabappleTrunkPlacer> CODEC = RecordCodecBuilder.create(crabappleTrunkPlacerInstance -> CrabappleTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)crabappleTrunkPlacerInstance).apply((Applicative)crabappleTrunkPlacerInstance, CrabappleTrunkPlacer::new));

    public CrabappleTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.CRABAPPLE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        CrabappleTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_(), (TreeConfiguration)pConfig);
        int maxHeight = pFreeTreeHeight;
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        List<Direction> directions = List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
        Direction movement = directions.get(pRandom.m_216339_(0, 4));
        boolean split = false;
        boolean branch1End = false;
        boolean branch2End = false;
        int horizontalOffset = 0;
        float splitChance = 0.0f;
        int i = 0;
        while (i < maxHeight) {
            splitChance += 0.1f;
            if (i > 0 && pRandom.m_188501_() < 0.2f) {
                split = true;
            }
            if (split) {
                if (!branch1End) {
                    this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_5484_(Direction.UP, i).m_5484_(movement, horizontalOffset), pConfig);
                    if (i > 1) {
                        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i).m_5484_(movement, horizontalOffset), 0, false));
                    }
                }
                if (!branch2End) {
                    this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_5484_(Direction.UP, i).m_5484_(movement, -horizontalOffset), pConfig);
                    if (i > 1) {
                        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i).m_5484_(movement, -horizontalOffset), 0, false));
                    }
                }
                if (i > 0) {
                    if (!branch1End) {
                        this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_5484_(Direction.UP, i - 1).m_5484_(movement, horizontalOffset), pConfig);
                    }
                    if (!branch2End) {
                        this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_5484_(Direction.UP, i - 1).m_5484_(movement, -horizontalOffset), pConfig);
                    }
                }
                if (branch1End == branch2End && (double)pRandom.m_188501_() < 0.25) {
                    if (pRandom.m_188499_()) {
                        branch1End = true;
                        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i).m_5484_(movement, horizontalOffset), 0, false));
                    } else {
                        branch2End = true;
                        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i).m_5484_(movement, -horizontalOffset), 0, false));
                    }
                }
                ++horizontalOffset;
            } else {
                this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_5484_(Direction.UP, i), pConfig);
            }
            if (++i <= maxHeight) continue;
            if (!split) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i), 0, false));
            }
            if (!branch1End && split) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i).m_5484_(movement, horizontalOffset), 0, false));
            }
            if (branch2End || !split) continue;
            foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, i).m_5484_(movement, -horizontalOffset), 0, false));
        }
        if (foliageAttachments.size() <= 1) {
            --horizontalOffset;
            if (!split) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, maxHeight), 0, false));
            }
            if (!branch1End && split) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, maxHeight - 1).m_5484_(movement, horizontalOffset), 0, false));
            }
            if (!branch2End && split) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_5484_(Direction.UP, maxHeight - 1).m_5484_(movement, -horizontalOffset), 0, false));
            }
        }
        return foliageAttachments;
    }
}

