/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cmparallelpipes.ponder;

import com.kreidev.cmparallelpipes.ParallelPipes;
import com.kreidev.cmparallelpipes.PipeWrenchItem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PonderScenes
implements PonderPlugin {
    public String getModId() {
        return "cmparallelpipes";
    }

    public void registerScenes(PonderSceneRegistrationHelper<ResourceLocation> helper) {
        PonderSceneRegistrationHelper HELPER = helper.withKeyFunction(RegistryEntry::getId);
        HELPER.addStoryBoard(ParallelPipes.PIPE_WRENCH_ITEM, "locked_pipe", PonderScenes::lockedPipe, new ResourceLocation[0]);
        HELPER.addStoryBoard(ParallelPipes.PIPE_WRENCH_ITEM, "outline_segments", PonderScenes::outlineSegment, new ResourceLocation[0]);
    }

    private static void lockedPipe(SceneBuilder scene, SceneBuildingUtil util) {
        BlockPos pipePos1 = util.grid().at(2, 1, 3);
        BlockPos pipePos2 = util.grid().at(1, 1, 3);
        BlockPos pipePos3 = util.grid().at(2, 1, 2);
        BlockPos pipePos4 = util.grid().at(1, 1, 2);
        scene.title("locked_pipe", "Locking Fluid Pipes");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.world().showSection(util.select().layer(1), Direction.UP);
        scene.idle(15);
        BlockState pipeBlock = (BlockState)((BlockState)PonderScenes.getNoDirectionPipe().m_61124_((Property)FluidPipeBlock.f_55150_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FluidPipeBlock.f_55148_, (Comparable)Boolean.valueOf(true));
        scene.world().setBlock(pipePos3, pipeBlock, true);
        scene.world().cycleBlockProperty(pipePos1, (Property)FluidPipeBlock.f_55148_);
        scene.idle(7);
        pipeBlock = (BlockState)((BlockState)PonderScenes.getNoDirectionPipe().m_61124_((Property)FluidPipeBlock.f_55150_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FluidPipeBlock.f_55149_, (Comparable)Boolean.valueOf(true));
        scene.world().setBlock(pipePos4, pipeBlock, true);
        scene.world().cycleBlockProperty(pipePos2, (Property)FluidPipeBlock.f_55148_);
        scene.world().cycleBlockProperty(pipePos3, (Property)FluidPipeBlock.f_55148_);
        scene.world().cycleBlockProperty(pipePos3, (Property)FluidPipeBlock.f_55151_);
        scene.idle(10);
        scene.overlay().showText(40).placeNearTarget().text("Fluid Pipes will always connect to other Fluid Pipes").pointAt(util.vector().topOf(pipePos3));
        scene.idle(60);
        scene.world().destroyBlock(pipePos4);
        scene.world().cycleBlockProperty(pipePos2, (Property)FluidPipeBlock.f_55148_);
        scene.world().cycleBlockProperty(pipePos3, (Property)FluidPipeBlock.f_55148_);
        scene.world().cycleBlockProperty(pipePos3, (Property)FluidPipeBlock.f_55151_);
        scene.idle(10);
        scene.overlay().showControls(util.vector().topOf(pipePos3), Pointing.DOWN, 60).rightClick().withItem(ParallelPipes.PIPE_WRENCH_ITEM.asStack());
        scene.idle(7);
        pipeBlock = (BlockState)((BlockState)PonderScenes.getNoDirectionPipe().m_61124_((Property)FluidPipeBlock.f_55150_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FluidPipeBlock.f_55148_, (Comparable)Boolean.valueOf(true));
        scene.world().setBlock(pipePos3, pipeBlock, true);
        scene.idle(10);
        scene.overlay().showText(70).placeNearTarget().text("The pipe wrench can be used to lock the pipe connectivity state similar to encased pipe").attachKeyFrame().pointAt(util.vector().topOf(pipePos3));
        scene.idle(80);
        pipeBlock = (BlockState)((BlockState)PonderScenes.getNoDirectionPipe().m_61124_((Property)FluidPipeBlock.f_55150_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FluidPipeBlock.f_55148_, (Comparable)Boolean.valueOf(true));
        scene.world().setBlock(pipePos4, pipeBlock, true);
        scene.world().cycleBlockProperty(pipePos2, (Property)FluidPipeBlock.f_55148_);
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(pipePos3), Pointing.DOWN, 60).rightClick().whileSneaking().withItem(ParallelPipes.PIPE_WRENCH_ITEM.asStack());
        scene.idle(7);
        pipeBlock = (BlockState)((BlockState)PonderScenes.getNoDirectionPipe().m_61124_((Property)FluidPipeBlock.f_55150_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FluidPipeBlock.f_55151_, (Comparable)Boolean.valueOf(true));
        scene.world().setBlock(pipePos3, pipeBlock, true);
        scene.world().cycleBlockProperty(pipePos4, (Property)FluidPipeBlock.f_55149_);
        scene.world().cycleBlockProperty(pipePos4, (Property)FluidPipeBlock.f_55148_);
        scene.idle(10);
        scene.overlay().showText(40).placeNearTarget().text("The fluid pipe can be unlocked again by sneak interact with the pipe wrench").attachKeyFrame().pointAt(util.vector().topOf(pipePos3));
        scene.idle(20);
    }

    private static void outlineSegment(SceneBuilder sceneBuilder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(sceneBuilder);
        scene.title("outline_segment", "Outlines and Connections");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        BlockPos pipePos = util.grid().at(1, 1, 2);
        AABB pipeBox1 = new AABB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0).m_82338_(pipePos);
        AABB pipeBox2 = new AABB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0).m_82338_(pipePos.m_122019_());
        AABB pipeBox3 = new AABB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0).m_82338_(pipePos.m_122019_().m_122019_());
        AABB pipeIntersectionBox = new AABB(0.25, 0.25, 0.0, 1.0, 0.75, 1.0).m_82338_(pipePos);
        AABB pipeCornerBox = new AABB(0.25, 0.25, 0.25, 1.0, 0.75, 1.0).m_82338_(pipePos);
        AABB eastSegment = PipeWrenchItem.SEGMENT_SHAPES.get(Direction.EAST).m_83215_().m_82338_(pipePos);
        AABB northSegment = PipeWrenchItem.SEGMENT_SHAPES.get(Direction.NORTH).m_83215_().m_82338_(pipePos);
        scene.world().showSection(util.select().everywhere(), Direction.UP);
        scene.idle(20);
        scene.overlay().showText(80).text("Locked pipes will show outlines when holding a pipe wrench").placeNearTarget();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)pipeBox1, pipeBox1, 80);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)pipeBox2, pipeBox2, 80);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)pipeBox3, pipeBox3, 80);
        scene.idle(100);
        scene.overlay().showText(100).text("You can configure pipe connections of locked pipes with a pipe wrench").placeNearTarget();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)pipeBox1, pipeBox1, 147);
        scene.idle(110);
        scene.overlay().showText(55).text("You can add an end point").pointAt(pipePos.m_252807_()).placeNearTarget().attachKeyFrame();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)eastSegment, eastSegment, 37);
        scene.idle(30);
        scene.overlay().showControls(util.vector().topOf(pipePos), Pointing.DOWN, 20).rightClick().withItem(ParallelPipes.PIPE_WRENCH_ITEM.asStack());
        scene.idle(7);
        scene.world().cycleBlockProperty(pipePos, (Property)FluidPipeBlock.f_55149_);
        scene.world().cycleBlockProperty(pipePos.m_122029_(), (Property)FluidPipeBlock.f_55151_);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)pipeBox1, pipeIntersectionBox, 67);
        scene.idle(30);
        scene.overlay().showText(55).text("... or remove one").pointAt(pipePos.m_252807_()).placeNearTarget();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, (Object)northSegment, northSegment, 37);
        scene.idle(30);
        scene.overlay().showControls(util.vector().topOf(pipePos), Pointing.DOWN, 20).rightClick().withItem(ParallelPipes.PIPE_WRENCH_ITEM.asStack());
        scene.idle(7);
        scene.world().cycleBlockProperty(pipePos, (Property)FluidPipeBlock.f_55148_);
        scene.world().cycleBlockProperty(pipePos.m_122012_(), (Property)FluidPipeBlock.f_55150_);
        scene.world().cycleBlockProperty(pipePos.m_122012_(), (Property)FluidPipeBlock.f_55152_);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)pipeBox1, pipeCornerBox, 60);
        scene.idle(30);
        scene.overlay().showText(120).text("But remember, a pipe needs at least 2 open endpoints or else you can't remove them.").placeNearTarget();
        scene.idle(60);
    }

    public static BlockState getNoDirectionPipe() {
        BlockState defaultState = AllBlocks.FLUID_PIPE.getDefaultState();
        for (BooleanProperty booleanProperty : FluidPipeBlock.f_55154_.values()) {
            defaultState = (BlockState)defaultState.m_61124_((Property)booleanProperty, (Comparable)Boolean.valueOf(false));
        }
        return defaultState;
    }
}

