/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicItem;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.createmod.catnip.data.WorldAttached;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SchematicInstances {
    private static final WorldAttached<Cache<Integer, SchematicLevel>> LOADED_SCHEMATICS = new WorldAttached($ -> CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());

    @Nullable
    public static SchematicLevel get(Level world, ItemStack schematic) {
        int hash;
        Cache map = (Cache)LOADED_SCHEMATICS.get((LevelAccessor)world);
        SchematicLevel ifPresent = (SchematicLevel)map.getIfPresent((Object)(hash = SchematicInstances.getHash(schematic)));
        if (ifPresent != null) {
            return ifPresent;
        }
        SchematicLevel loadWorld = SchematicInstances.loadWorld(world, schematic);
        if (loadWorld == null) {
            return null;
        }
        map.put((Object)hash, (Object)loadWorld);
        return loadWorld;
    }

    private static SchematicLevel loadWorld(Level wrapped, ItemStack schematic) {
        if (schematic == null || !schematic.m_41782_()) {
            return null;
        }
        if (!schematic.m_41783_().m_128471_("Deployed")) {
            return null;
        }
        StructureTemplate activeTemplate = SchematicItem.loadSchematic(wrapped, schematic);
        if (activeTemplate.m_163801_().equals((Object)Vec3i.f_123288_)) {
            return null;
        }
        BlockPos anchor = NbtUtils.m_129239_((CompoundTag)schematic.m_41783_().m_128469_("Anchor"));
        SchematicLevel world = new SchematicLevel(anchor, wrapped);
        StructurePlaceSettings settings = SchematicItem.getSettings(schematic);
        activeTemplate.m_230328_((ServerLevelAccessor)world, anchor, anchor, settings, wrapped.m_213780_(), 2);
        StructureTransform transform = new StructureTransform(settings.m_74407_(), Direction.Axis.Y, settings.m_74404_(), settings.m_74401_());
        for (BlockEntity be : world.getBlockEntities()) {
            transform.apply(be);
        }
        return world;
    }

    public static void clearHash(ItemStack schematic) {
        if (schematic == null || !schematic.m_41782_()) {
            return;
        }
        schematic.m_41783_().m_128473_("SchematicHash");
    }

    public static int getHash(ItemStack schematic) {
        if (schematic == null || !schematic.m_41782_()) {
            return -1;
        }
        CompoundTag tag = schematic.m_41783_();
        if (!tag.m_128441_("SchematicHash")) {
            tag.m_128405_("SchematicHash", tag.toString().hashCode());
        }
        return tag.m_128451_("SchematicHash");
    }
}

