/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.datagen;

import com.nukateam.cgs.common.datagen.providers.CgsBlockStateProvider;
import com.nukateam.cgs.common.datagen.providers.CgsBlockTagGenerator;
import com.nukateam.cgs.common.datagen.providers.CgsItemModelProvider;
import com.nukateam.cgs.common.datagen.providers.CgsItemTagGenerator;
import com.nukateam.cgs.common.datagen.providers.CgsLootTableProvider;
import com.nukateam.cgs.common.datagen.providers.CgsPoiTypeTagsProvider;
import com.nukateam.cgs.common.datagen.providers.CgsRecipeProvider;
import com.nukateam.cgs.common.datagen.providers.CgsWorldGenProvider;
import com.nukateam.cgs.common.datagen.providers.create.CgsCrushingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsCuttingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsDeployingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsEmptyingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsFillingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsMechanicalCraftingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsMixingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsPressingRecipeGen;
import com.nukateam.cgs.common.datagen.providers.create.CgsSequencedAssemblyRecipeGen;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new CgsItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsMechanicalCraftingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsSequencedAssemblyRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsMixingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsPressingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsCrushingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsDeployingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsFillingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsEmptyingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsCuttingRecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)CgsLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new CgsBlockStateProvider(packOutput, fileHelper));
        CgsBlockTagGenerator blockTagGenerator = (CgsBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new CgsBlockTagGenerator(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsPoiTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CgsWorldGenProvider(packOutput, lookupProvider));
    }
}

