/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.faundation.registry;

import com.nukateam.cgs.common.datagen.annotations.BlockStateGen;
import com.nukateam.cgs.common.faundation.block.GuanoPileBlock;
import com.nukateam.cgs.common.faundation.registry.items.CgsItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CgsBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"cgs");
    @BlockStateGen
    public static final RegistryObject<Block> SULFUR_ORE = CgsBlocks.registerBlock("sulfur_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56720_).m_284180_(MapColor.f_283820_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60978_(0.4f)));
    @BlockStateGen
    public static final RegistryObject<Block> LEAD_ORE = CgsBlocks.registerBlock("lead_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(3.0f, 3.0f)));
    @BlockStateGen
    public static final RegistryObject<Block> DEEPSLATE_LEAD_ORE = CgsBlocks.registerBlock("deepslate_lead_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_284180_(MapColor.f_283875_).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    @BlockStateGen
    public static final RegistryObject<Block> RAW_LEAD_BLOCK = CgsBlocks.registerBlock("raw_lead_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283877_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(5.0f, 6.0f)));
    @BlockStateGen
    public static final RegistryObject<Block> LEAD_BLOCK = CgsBlocks.registerBlock("lead_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    @BlockStateGen
    public static final RegistryObject<Block> STEEL_BLOCK = CgsBlocks.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> GUANO_BLOCK = CgsBlocks.registerBlockWithoutItem("guano_block", () -> new GuanoPileBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50125_).m_60978_(0.5f).m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_154661_).m_60977_().m_60955_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        CgsItems.ITEMS.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

