/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.heater;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.heat.heater.HeaterBlock;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.Nullable;

public class HeaterBlockEntity
extends BlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    public float heat = 0.0f;

    public HeaterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.heat = tag.m_128457_("heat");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("heat", this.heat);
    }

    @Override
    public boolean canConnect(Direction from) {
        return from != Direction.DOWN;
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.m_6596_();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    @Nullable
    public float[] getHeatTiers() {
        return new float[]{50.0f, 100.0f, 400.0f, 500.0f};
    }

    @Override
    public float getTierHeat() {
        BlazeBurnerBlock.HeatLevel strength = (BlazeBurnerBlock.HeatLevel)this.m_58900_().m_61143_(HeaterBlock.STRENGTH);
        double heat = 0.0;
        Double mult = (Double)NewAgeConfig.getCommon().heaterRequiredHeatMultiplier.get();
        switch (strength) {
            case NONE: {
                heat = 0.0;
                break;
            }
            case SMOULDERING: {
                heat = 50.0 * mult;
                break;
            }
            case FADING: {
                heat = 100.0 * mult;
                break;
            }
            case KINDLED: {
                heat = 400.0 * mult;
                break;
            }
            case SEETHING: {
                heat = 500.0 * mult;
            }
        }
        return (float)heat;
    }

    @Override
    public double getHeatTierMultiplier() {
        return (Double)NewAgeConfig.getCommon().heaterRequiredHeatMultiplier.get();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        BlazeBurnerBlock.HeatLevel strength = (BlazeBurnerBlock.HeatLevel)this.m_58900_().m_61143_(HeaterBlock.STRENGTH);
        double heat = 0.0;
        Double mult = (Double)NewAgeConfig.getCommon().heaterRequiredHeatMultiplier.get();
        switch (strength) {
            case NONE: {
                heat = 0.0;
                break;
            }
            case SMOULDERING: {
                heat = 50.0 * mult;
                break;
            }
            case FADING: {
                heat = 100.0 * mult;
                break;
            }
            case KINDLED: {
                heat = 400.0 * mult;
                break;
            }
            case SEETHING: {
                heat = 500.0 * mult;
            }
        }
        CreateLang.translate((String)"tooltip.create_new_age.releasing", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.temperature.ps", (Object[])new Object[]{StringFormattingTool.formatFloat((float)heat)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return true;
    }
}

