/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.TubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.smarttube.ITubeAttachment;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class ActionTubeBlock
extends TubeBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public ActionTubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract BooleanProperty propertyToUpdate();

    public boolean m_7899_(@NotNull BlockState state) {
        return super.m_7899_(state);
    }

    public int m_6376_(@NotNull BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        return this.m_6378_(blockState, blockAccess, pos, side);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        int currentPower = (Integer)state.m_61143_((Property)POWER);
        if (currentPower > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)), 3);
            level.m_46672_(pos, (Block)this);
        }
    }

    public int m_6378_(@NotNull BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        BlockEntity blockEntity = blockAccess.m_7702_(pos);
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return 0;
        }
        ActionTubeBlockEntity action = (ActionTubeBlockEntity)blockEntity;
        if (!action.hasTubeAttachment(side.m_122424_()) || !action.canEmitTo(side.m_122424_())) {
            return 0;
        }
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    protected boolean getSignalSide(Level level, BlockPos pos, List<Direction> checkSides) {
        for (Direction direction : checkSides) {
            if (level.m_277185_(pos.m_121945_(direction), direction) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSignalOnSide(Level level, BlockPos pos, Direction side) {
        return level.m_277185_(pos.m_121945_(side), side) > 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        ActionTubeBlockEntity tubeBlockEntity = (ActionTubeBlockEntity)world.m_7702_(pos);
        if (tubeBlockEntity == null) {
            return false;
        }
        return side != null && side != state.m_61143_((Property)FACING) && side != ((Direction)state.m_61143_((Property)FACING)).m_122424_() && tubeBlockEntity.getAttachmentDirections().contains(side.m_122424_());
    }

    public static boolean canPlaceAttachment(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && side != state.m_61143_((Property)FACING) && side != ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public void m_6861_(BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        ActionTubeBlockEntity tubeBlockEntity = (ActionTubeBlockEntity)level.m_7702_(pos);
        if (tubeBlockEntity == null) {
            return;
        }
        boolean neighborHasSignal = this.getSignalSide(level, pos, tubeBlockEntity.getAttachmentDirectionsNoEmit());
        boolean actualState = (Boolean)state.m_61143_((Property)POWERED);
        if (neighborHasSignal && !actualState) {
            level.m_186460_(pos, (Block)this, 4);
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)this.propertyToUpdate(), (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)this.propertyToUpdate()) == false)), 2);
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        } else if (!neighborHasSignal && actualState) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)this.propertyToUpdate(), (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)this.propertyToUpdate()) == false)), 2);
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        }
    }

    @Override
    void dropBlockToPlayer(boolean isWrenched, Level level, BlockPos pos, Player player, BlockEntity blockEntity, int amount) {
        super.dropBlockToPlayer(isWrenched, level, pos, player, blockEntity, amount);
        if (player.m_7500_()) {
            return;
        }
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return;
        }
        ActionTubeBlockEntity actionTubeBlock = (ActionTubeBlockEntity)blockEntity;
        actionTubeBlock.getTubeAttachments().forEach((dir, attachment) -> {
            ItemStack stack = attachment.getItemStack();
            if (isWrenched) {
                player.m_150109_().m_150079_(stack);
            } else {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            }
        });
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(clickedPos);
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return InteractionResult.PASS;
        }
        ActionTubeBlockEntity action = (ActionTubeBlockEntity)blockEntity;
        if (!action.hasTubeAttachment(clickedFace)) {
            return InteractionResult.PASS;
        }
        ITubeAttachment iTubeAttachment = action.removeTubeAttachment(clickedFace);
        if (iTubeAttachment == null) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        if (!player.m_7500_()) {
            ItemStack stack = iTubeAttachment.getItemStack();
            player.m_150109_().m_150079_(stack);
        }
        IWrenchable.playRemoveSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
        return InteractionResult.SUCCESS;
    }
}

